/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.bpm.chart.core.primitives.Primitive;
import oracle.bpm.geom.Point;

public class SceneGraph {
    private ArrayList<Primitive> primitiveList = new ArrayList();

    public void add(Primitive o) {
        this.primitiveList.add(o);
    }

    public void validate(Primitive o) {
        if (!this.primitiveList.contains(o)) {
            this.primitiveList.add(o);
        }
    }

    public Iterator<Primitive> getEnumerator() {
        return this.primitiveList.iterator();
    }

    public int count() {
        return this.primitiveList.size();
    }

    public void clear() {
        this.primitiveList.clear();
    }

    public Primitive getPrimitiveFromRowColumn(int row, int column) {
        return this.recursePrimitivesRowColumn(this.primitiveList, row, column);
    }

    public Primitive getPrimitiveFromPoint(Point point) {
        return this.recursePrimitivesHitTest(this.primitiveList, point);
    }

    public Primitive get(int index) {
        return index < 0 || index >= this.count() ? null : this.primitiveList.get(index);
    }

    private Primitive recursePrimitivesRowColumn(Object primitives, int row, int column) {
        if (primitives == null) {
            return null;
        }
        boolean list = primitives == this.primitiveList;
        int iNum = list ? this.primitiveList.size() : ((Primitive[])primitives).length;
        for (int i = 0; i < iNum; ++i) {
            Primitive pi1 = list ? this.primitiveList.get(i) : ((Primitive[])primitives)[i];
            Primitive pi2 = this.recursePrimitivesRowColumn(pi1.getPrimitives(), row, column);
            if (pi2 != null) {
                return pi2;
            }
            if (!pi1.hitMe || pi1.row != row || pi1.column != column) continue;
            return pi1;
        }
        return null;
    }

    private Primitive recursePrimitivesHitTest(Object primitives, Point point) {
        int i;
        if (primitives == null) {
            return null;
        }
        boolean list = primitives == this.primitiveList;
        int n = i = list ? this.primitiveList.size() : ((Primitive[])primitives).length;
        while (i-- > 0) {
            Primitive pi1 = list ? this.primitiveList.get(i) : ((Primitive[])primitives)[i];
            if (pi1 == null || !pi1.hitMe) continue;
            Primitive pi2 = this.recursePrimitivesHitTest(pi1.getPrimitives(), point);
            if (pi2 != null) {
                return pi2;
            }
            if (!pi1.hitTest(point)) continue;
            return pi1;
        }
        return null;
    }
}

