/*
 * Decompiled with CFR 0.152.
 */
package fuego.parser;

import fuego.parser.TokenManager;
import fuego.parser.TokenSymbol;
import fuego.parser.Tool;
import fuego.parser.collections.impl.Vector;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

class SimpleTokenManager
implements TokenManager,
Cloneable {
    protected Tool antlrTool;
    protected int maxToken = 4;
    protected String name;
    protected boolean readOnly = false;
    protected Vector<String> vocabulary;
    private Map<String, TokenSymbol> table;

    SimpleTokenManager(String name_, Tool tool_) {
        this.antlrTool = tool_;
        this.name = name_;
        this.vocabulary = new Vector(1);
        this.table = new Hashtable<String, TokenSymbol>();
        TokenSymbol ts = new TokenSymbol("EOF");
        ts.setTokenType(1);
        this.define(ts);
        this.vocabulary.ensureCapacity(3);
        this.vocabulary.setElementAt("NULL_TREE_LOOKAHEAD", 3);
    }

    @Override
    public void setName(String name_) {
        this.name = name_;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getTokenStringAt(int idx) {
        return this.vocabulary.elementAt(idx);
    }

    @Override
    public TokenSymbol getTokenSymbol(String sym) {
        return this.table.get(sym);
    }

    @Override
    public TokenSymbol getTokenSymbolAt(int idx) {
        return this.getTokenSymbol(this.getTokenStringAt(idx));
    }

    @Override
    public Set<String> getTokenSymbolKeys() {
        return this.table.keySet();
    }

    @Override
    public Vector getVocabulary() {
        return this.vocabulary;
    }

    @Override
    public SimpleTokenManager clone() {
        SimpleTokenManager tm;
        try {
            tm = (SimpleTokenManager)super.clone();
            tm.vocabulary = this.vocabulary.clone();
            tm.table = new Hashtable<String, TokenSymbol>(this.table);
            tm.maxToken = this.maxToken;
            tm.antlrTool = this.antlrTool;
            tm.name = this.name;
        }
        catch (CloneNotSupportedException e) {
            this.antlrTool.fatalError("panic: cannot clone token manager");
            return null;
        }
        return tm;
    }

    @Override
    public void define(TokenSymbol ts) {
        this.vocabulary.ensureCapacity(ts.getTokenType());
        this.vocabulary.setElementAt(ts.getId(), ts.getTokenType());
        this.mapToTokenSymbol(ts.getId(), ts);
    }

    @Override
    public void mapToTokenSymbol(String nm, TokenSymbol sym) {
        this.table.put(nm, sym);
    }

    @Override
    public int maxTokenType() {
        return this.maxToken - 1;
    }

    @Override
    public int nextTokenType() {
        return this.maxToken++;
    }

    @Override
    public boolean tokenDefined(String symbol) {
        return this.table.containsKey(symbol);
    }
}

