/*
 * Decompiled with CFR 0.152.
 */
package fuego.parser;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class PreservingFileWriter
extends FileWriter {
    protected File target_file;
    protected File tmp_file;

    public PreservingFileWriter(String file) throws IOException {
        super(file + ".fuego.parser.tmp");
        this.target_file = new File(file);
        File parentdir = this.target_file.getParentFile();
        if (parentdir != null) {
            if (!parentdir.exists()) {
                throw new IOException("destination directory of '" + file + "' doesn't exist");
            }
            if (!parentdir.canWrite()) {
                throw new IOException("destination directory of '" + file + "' isn't writeable");
            }
        }
        if (this.target_file.exists() && !this.target_file.canWrite()) {
            throw new IOException("cannot write to '" + file + "'");
        }
        this.tmp_file = new File(file + ".fuego.parser.tmp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Reader source = null;
        Writer target = null;
        try {
            int cnt;
            super.close();
            char[] buffer = new char[1024];
            if (this.target_file.length() == this.tmp_file.length()) {
                source = new BufferedReader(new FileReader(this.tmp_file));
                BufferedReader tmp = new BufferedReader(new FileReader(this.target_file));
                boolean equal = true;
                char[] buf2 = new char[1024];
                block16: while (equal) {
                    int cnt2;
                    int cnt1 = source.read(buffer, 0, 1024);
                    if (cnt1 != (cnt2 = ((Reader)tmp).read(buf2, 0, 1024))) {
                        equal = false;
                        break;
                    }
                    if (cnt1 == -1) break;
                    for (int i = 0; i < cnt1; ++i) {
                        if (buffer[i] == buf2[i]) continue;
                        equal = false;
                        continue block16;
                    }
                }
                source.close();
                ((Reader)tmp).close();
                if (equal) {
                    return;
                }
            }
            source = new BufferedReader(new FileReader(this.tmp_file));
            target = new BufferedWriter(new FileWriter(this.target_file));
            while ((cnt = source.read(buffer, 0, 1024)) != -1) {
                target.write(buffer, 0, cnt);
            }
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException e) {}
            }
            if (target != null) {
                try {
                    target.close();
                }
                catch (IOException e) {}
            }
            if (this.tmp_file != null && this.tmp_file.exists()) {
                this.tmp_file.delete();
                this.tmp_file = null;
            }
        }
    }
}

