/*
 * Decompiled with CFR 0.152.
 */
package fuego.parser;

import fuego.parser.ActionElement;
import fuego.parser.ActionTransInfo;
import fuego.parser.Alternative;
import fuego.parser.AlternativeBlock;
import fuego.parser.AlternativeElement;
import fuego.parser.BlockEndElement;
import fuego.parser.CharLiteralElement;
import fuego.parser.CharRangeElement;
import fuego.parser.CharStreamException;
import fuego.parser.CodeGenerator;
import fuego.parser.ExceptionHandler;
import fuego.parser.ExceptionSpec;
import fuego.parser.Grammar;
import fuego.parser.GrammarAtom;
import fuego.parser.JavaBlockFinishingInfo;
import fuego.parser.JavaCharFormatter;
import fuego.parser.LexerGrammar;
import fuego.parser.Lookahead;
import fuego.parser.MakeGrammar;
import fuego.parser.OneOrMoreBlock;
import fuego.parser.ParserGrammar;
import fuego.parser.RecognitionException;
import fuego.parser.RuleBlock;
import fuego.parser.RuleRefElement;
import fuego.parser.RuleSymbol;
import fuego.parser.StringLiteralElement;
import fuego.parser.StringLiteralSymbol;
import fuego.parser.SynPredBlock;
import fuego.parser.Token;
import fuego.parser.TokenManager;
import fuego.parser.TokenRangeElement;
import fuego.parser.TokenRefElement;
import fuego.parser.TokenStreamException;
import fuego.parser.TokenSymbol;
import fuego.parser.Tool;
import fuego.parser.TreeElement;
import fuego.parser.TreeWalkerGrammar;
import fuego.parser.WildcardElement;
import fuego.parser.ZeroOrMoreBlock;
import fuego.parser.actions.java.ActionLexer;
import fuego.parser.collections.impl.BitSet;
import fuego.parser.collections.impl.Vector;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import oracle.bpm.lang.Str;

public class JavaCodeGenerator
extends CodeGenerator {
    protected boolean genAST = false;
    protected boolean saveText = false;
    protected int syntacticPredLevel = 0;
    int astVarNumber = 1;
    String commonExtraArgs;
    String commonExtraParams;
    String commonLocalVars;
    String currentASTResult;
    RuleBlock currentRule;
    HashSet<AlternativeElement> declaredASTVariables = new HashSet();
    String exceptionThrown;
    String labeledElementASTType;
    String labeledElementInit;
    String labeledElementType;
    String lt1Value;
    String throwNoViable;
    Hashtable<String, String> treeVariableMap = new Hashtable();
    private Vector<String> semPreds;
    protected static final String NONUNIQUE = "NONUNIQUE";
    public static final int caseSizeThreshold = 127;

    public JavaCodeGenerator() {
        this.charFormatter = new JavaCharFormatter();
    }

    public static String bitSetGen(BitSet p) {
        String elems = p.toCompressedString();
        int length = elems.length();
        StringBuilder sb = new StringBuilder(length + 20);
        sb.append("BitSet.create(\"");
        for (int i = 0; i < length; ++i) {
            char c = elems.charAt(i);
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c >= ' ' && c <= '~') {
                sb.append(c);
                continue;
            }
            sb.append(String.format("\\u%04X", c));
        }
        sb.append("\")");
        return sb.toString();
    }

    @Override
    public String getASTCreateString(Vector v) {
        int length = v.size();
        if (length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        if (this.grammar.inlineASTFactory) {
            this.grammar.makeArrayLengths.add(length);
            if (length <= 10) {
                buf.append("make(");
                for (int i = 0; i < length; ++i) {
                    buf.append(v.elementAt(i));
                    if (i + 1 >= length) continue;
                    buf.append(", ");
                }
                buf.append(")");
            } else {
                String cast = "AST".equals(this.labeledElementASTType) ? "" : "(" + this.labeledElementASTType + ") ";
                buf.append(cast);
                buf.append("astFactory.make(new AST[] {");
                for (int i = 0; i < length; ++i) {
                    buf.append(v.elementAt(i));
                    if (i + 1 >= length) continue;
                    buf.append(", ");
                }
                buf.append("})");
            }
        } else {
            String cast = "AST".equals(this.labeledElementASTType) ? "" : "(" + this.labeledElementASTType + ") ";
            buf.append(cast);
            buf.append("astFactory.make( (new ASTArray(");
            buf.append(length);
            buf.append("))");
            for (int i = 0; i < length; ++i) {
                buf.append(".add(");
                buf.append(v.elementAt(i));
                buf.append(")");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    @Override
    public String getASTCreateString(GrammarAtom atom, String astCtorArgs) {
        if (atom != null && atom.getASTNodeType() != null) {
            return " new " + atom.getASTNodeType() + "(" + astCtorArgs + ")";
        }
        return this.getASTCreateString(astCtorArgs);
    }

    public String getASTCreateString(String astCtorArgs) {
        if (astCtorArgs == null) {
            astCtorArgs = "";
        }
        int nCommas = 0;
        for (int i = 0; i < astCtorArgs.length(); ++i) {
            if (astCtorArgs.charAt(i) != ',') continue;
            ++nCommas;
        }
        if (nCommas < 2) {
            TokenSymbol ts;
            int firstComma = astCtorArgs.indexOf(44);
            String tokenName = astCtorArgs;
            if (nCommas > 0) {
                tokenName = astCtorArgs.substring(0, firstComma);
            }
            if ((ts = this.grammar.tokenManager.getTokenSymbol(tokenName)) != null) {
                String astNodeType = ts.getASTNodeType();
                String emptyText = "";
                if (nCommas == 0) {
                    emptyText = ",\"\"";
                }
                if (astNodeType != null) {
                    return "(" + astNodeType + ")" + "astFactory.create(" + astCtorArgs + emptyText + ",\"" + astNodeType + "\")";
                }
                return "astFactory.create(" + astCtorArgs + ")";
            }
            if ("AST".equals(this.labeledElementASTType)) {
                return "astFactory.create(" + astCtorArgs + ")";
            }
            return "(" + this.labeledElementASTType + ")" + "astFactory.create(" + astCtorArgs + ")";
        }
        return "(" + this.labeledElementASTType + ")astFactory.create(" + astCtorArgs + ")";
    }

    public String getRangeExpression(int k, int[] elems) {
        if (!JavaCodeGenerator.elementsAreRange(elems)) {
            this.antlrTool.fatalError("panic: getRangeExpression called with non-range");
        }
        int begin = elems[0];
        int end = elems[elems.length - 1];
        return "(" + this.lookaheadString(k) + " >= " + this.getValueString(begin) + " && " + this.lookaheadString(k) + " <= " + this.getValueString(end) + ")";
    }

    public void exitIfError() {
        if (this.antlrTool.hasError()) {
            this.antlrTool.fatalError("Exiting due to errors.");
        }
    }

    @Override
    public void gen() {
        try {
            for (Grammar o : this.behavior.grammars.values()) {
                this.generateGrammar(o);
            }
            Iterator<TokenManager> iterator = this.behavior.tokenManagers.values().iterator();
            while (iterator.hasNext()) {
                this.generateTokens(iterator);
            }
        }
        catch (IOException e) {
            this.antlrTool.reportException(e, null);
        }
    }

    @Override
    public void gen(ActionElement action) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genAction(" + action + ")");
        }
        if (action.isSemPred) {
            this.genSemPred(action.actionText, action.line);
        } else {
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if ( inputState.guessing==0 ) {");
                ++this.tabs;
            }
            ActionTransInfo tInfo = new ActionTransInfo();
            String actionStr = this.processActionForSpecialSymbols(action.actionText, action.getLine(), this.currentRule, tInfo);
            if (tInfo.refRuleRoot != null) {
                this.println(tInfo.refRuleRoot + " = " + this.getRootReference() + ";");
            }
            this.printAction(actionStr);
            this.manageAssignToRoot(tInfo);
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("}");
            }
        }
    }

    @Override
    public void gen(AlternativeBlock blk) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen(" + blk + ")");
        }
        this.println("{");
        this.genBlockPreamble(blk);
        this.genBlockInitAction(blk);
        String saveCurrentASTResult = this.currentASTResult;
        if (blk.getLabel() != null) {
            this.currentASTResult = blk.getLabel();
        }
        this.grammar.theLLkAnalyzer.deterministic(blk);
        JavaBlockFinishingInfo howToFinish = this.genCommonBlock(blk, true);
        this.genBlockFinish(howToFinish, this.getThrowNoViableAlt(blk.enclosingRuleName));
        this.println("}");
        this.currentASTResult = saveCurrentASTResult;
    }

    @Override
    public void gen(BlockEndElement end) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRuleEnd(" + end + ")");
        }
    }

    @Override
    public void gen(CharLiteralElement atom) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genChar(" + atom + ")");
        }
        if (atom.getLabel() != null) {
            this.println(atom.getLabel() + " = " + this.lt1Value + ";");
        }
        boolean oldsaveText = this.saveText;
        this.saveText = this.saveText && atom.getAutoGenType() == 1;
        this.genMatch(atom);
        this.saveText = oldsaveText;
    }

    @Override
    public void gen(CharRangeElement r) {
        boolean flag;
        if (r.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(r.getLabel() + " = " + this.lt1Value + ";");
        }
        boolean bl = flag = this.grammar instanceof LexerGrammar && (!this.saveText || r.getAutoGenType() == 3);
        if (flag) {
            this.println("_saveIndex=text.length();");
        }
        this.println("matchRange(" + r.beginText + "," + r.endText + ");");
        if (flag) {
            this.println("text.setLength(_saveIndex);");
        }
    }

    @Override
    public void gen(OneOrMoreBlock blk) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen+(" + blk + ")");
        }
        this.println("{");
        this.genBlockPreamble(blk);
        String cnt = "_cnt_" + (blk.getLabel() != null ? blk.getLabel() : Integer.valueOf(blk.ID));
        this.println("int " + cnt + "=0;");
        String label = blk.getLabel() != null ? blk.getLabel() : "_loop" + blk.ID;
        this.println(label + ":");
        this.println("do {");
        ++this.tabs;
        this.genBlockInitAction(blk);
        String saveCurrentASTResult = this.currentASTResult;
        if (blk.getLabel() != null) {
            this.currentASTResult = blk.getLabel();
        }
        this.grammar.theLLkAnalyzer.deterministic(blk);
        boolean generateNonGreedyExitPath = false;
        int nonGreedyExitDepth = this.grammar.maxk;
        if (!blk.greedy && blk.exitLookaheadDepth <= this.grammar.maxk && blk.exitCache[blk.exitLookaheadDepth].containsEpsilon()) {
            generateNonGreedyExitPath = true;
            nonGreedyExitDepth = blk.exitLookaheadDepth;
        } else if (!blk.greedy && blk.exitLookaheadDepth == Integer.MAX_VALUE) {
            generateNonGreedyExitPath = true;
        }
        if (generateNonGreedyExitPath) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("nongreedy (...)+ loop; exit depth is " + blk.exitLookaheadDepth);
            }
            String predictExit = this.getLookaheadTestExpression(blk.exitCache, nonGreedyExitDepth);
            this.println("// nongreedy exit test");
            this.println("if ( " + cnt + ">=1 && " + predictExit + ") break " + label + ";");
        }
        JavaBlockFinishingInfo howToFinish = this.genCommonBlock(blk, false);
        String noViable = this.getThrowNoViableAlt(blk.enclosingRuleName);
        this.genBlockFinish(howToFinish, "if ( " + cnt + ">=1 ) { break " + label + "; } else {" + noViable + "}");
        this.println(cnt + "++;");
        --this.tabs;
        this.println("} while (true);");
        this.println("}");
        this.currentASTResult = saveCurrentASTResult;
    }

    @Override
    public void gen(RuleRefElement rr) {
        RuleSymbol rs;
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRR(" + rr + ")");
        }
        if ((rs = (RuleSymbol)this.grammar.getSymbol(rr.targetRule)) == null || !rs.isDefined()) {
            this.antlrTool.error("Rule '" + rr.targetRule + "' is not defined", this.grammar.getFilename(), rr.getLine(), rr.getColumn());
            return;
        }
        this.genErrorTryForElement(rr);
        if (this.grammar instanceof TreeWalkerGrammar && rr.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(rr.getLabel() + " = _t==ASTNULL ? null : " + this.lt1Value + ";");
        }
        if (this.grammar instanceof LexerGrammar && (!this.saveText || rr.getAutoGenType() == 3)) {
            this.println("_saveIndex=text.length();");
        }
        this.printTabs();
        if (rr.idAssign != null) {
            if (rs.block.returnAction == null) {
                this.antlrTool.warning("Rule '" + rr.targetRule + "' has no return type", this.grammar.getFilename(), rr.getLine(), rr.getColumn());
            }
            this._print(rr.idAssign + "=");
        } else if (!(this.grammar instanceof LexerGrammar) && this.syntacticPredLevel == 0 && rs.block.returnAction != null) {
            this.antlrTool.warning("Rule '" + rr.targetRule + "' returns a value", this.grammar.getFilename(), rr.getLine(), rr.getColumn());
        }
        this.GenRuleInvocation(rr);
        if (this.grammar instanceof LexerGrammar && (!this.saveText || rr.getAutoGenType() == 3)) {
            this.println("text.setLength(_saveIndex);");
        }
        if (this.syntacticPredLevel == 0) {
            this.genNotInSyntaticPredicate(rr);
        }
        this.genErrorCatchForElement(rr);
    }

    @Override
    public void gen(StringLiteralElement atom) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genString(" + atom + ")");
        }
        if (atom.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(atom.getLabel() + " = " + this.lt1Value + ";");
        }
        this.genElementAST(atom);
        boolean oldsaveText = this.saveText;
        this.saveText = this.saveText && atom.getAutoGenType() == 1;
        this.genMatch(atom);
        this.saveText = oldsaveText;
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t.getNextSibling();");
        }
    }

    @Override
    public void gen(TokenRangeElement r) {
        this.genErrorTryForElement(r);
        if (r.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(r.getLabel() + " = " + this.lt1Value + ";");
        }
        this.genElementAST(r);
        this.println("matchRange(" + r.beginText + "," + r.endText + ");");
        this.genErrorCatchForElement(r);
    }

    @Override
    public void gen(TokenRefElement atom) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genTokenRef(" + atom + ")");
        }
        if (this.grammar instanceof LexerGrammar) {
            this.antlrTool.fatalError("panic: Token reference found in lexer");
        }
        this.genErrorTryForElement(atom);
        if (atom.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(atom.getLabel() + " = " + this.lt1Value + ";");
        }
        this.genElementAST(atom);
        this.genMatch(atom);
        this.genErrorCatchForElement(atom);
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t.getNextSibling();");
        }
    }

    @Override
    public void gen(TreeElement t) {
        this.println(this.labeledElementASTType + " __t" + t.ID + " = _t;");
        if (t.root.getLabel() != null) {
            this.println(t.root.getLabel() + " = _t==ASTNULL ? null :(" + this.labeledElementASTType + ")_t;");
        }
        if (t.root.getAutoGenType() == 3) {
            this.antlrTool.error("Suffixing a root node with '!' is not implemented", this.grammar.getFilename(), t.getLine(), t.getColumn());
            t.root.setAutoGenType(1);
        }
        if (t.root.getAutoGenType() == 2) {
            this.antlrTool.warning("Suffixing a root node with '^' is redundant; already a root", this.grammar.getFilename(), t.getLine(), t.getColumn());
            t.root.setAutoGenType(1);
        }
        this.genElementAST(t.root);
        if (this.grammar.buildAST) {
            this.println("fuego.parser.ASTPair __currentAST" + t.ID + " = currentAST.copy();");
            this.println("currentAST.root = currentAST.child;");
            this.println("currentAST.child = null;");
        }
        if (t.root instanceof WildcardElement) {
            this.println("if ( _t==null ) throw new fuego.parser.MismatchedTokenException();");
        } else {
            this.genMatch(t.root);
        }
        this.println("_t = _t.getFirstChild();");
        for (int i = 0; i < t.getAlternatives().size(); ++i) {
            Alternative a = t.getAlternativeAt(i);
            AlternativeElement e = a.head;
            while (e != null) {
                e.generate();
                e = e.next;
            }
        }
        if (this.grammar.buildAST) {
            this.println("currentAST = __currentAST" + t.ID + ";");
        }
        this.println("_t = __t" + t.ID + ";");
        this.println("_t = _t.getNextSibling();");
    }

    @Override
    public void gen(WildcardElement wc) {
        if (wc.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(wc.getLabel() + " = " + this.lt1Value + ";");
        }
        this.genElementAST(wc);
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("if ( _t==null ) throw new fuego.parser.MismatchedTokenException();");
        } else if (this.grammar instanceof LexerGrammar) {
            if (!this.saveText || wc.getAutoGenType() == 3) {
                this.println("_saveIndex=text.length();");
            }
            this.println("matchNot(EOF_CHAR);");
            if (this.grammar instanceof LexerGrammar && (!this.saveText || wc.getAutoGenType() == 3)) {
                this.println("text.setLength(_saveIndex);");
            }
        } else {
            this.println("matchNot(" + this.getValueString(1) + ");");
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t.getNextSibling();");
        }
    }

    @Override
    public void gen(ZeroOrMoreBlock blk) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen*(" + blk + ")");
        }
        this.println("{");
        this.genBlockPreamble(blk);
        String label = blk.getLabel() != null ? blk.getLabel() : "_loop" + blk.ID;
        this.println(label + ":");
        this.println("do {");
        ++this.tabs;
        this.genBlockInitAction(blk);
        String saveCurrentASTResult = this.currentASTResult;
        if (blk.getLabel() != null) {
            this.currentASTResult = blk.getLabel();
        }
        this.grammar.theLLkAnalyzer.deterministic(blk);
        boolean generateNonGreedyExitPath = false;
        int nonGreedyExitDepth = this.grammar.maxk;
        if (!blk.greedy && blk.exitLookaheadDepth <= this.grammar.maxk && blk.exitCache[blk.exitLookaheadDepth].containsEpsilon()) {
            generateNonGreedyExitPath = true;
            nonGreedyExitDepth = blk.exitLookaheadDepth;
        } else if (!blk.greedy && blk.exitLookaheadDepth == Integer.MAX_VALUE) {
            generateNonGreedyExitPath = true;
        }
        if (generateNonGreedyExitPath) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("nongreedy (...)* loop; exit depth is " + blk.exitLookaheadDepth);
            }
            String predictExit = this.getLookaheadTestExpression(blk.exitCache, nonGreedyExitDepth);
            this.println("// nongreedy exit test");
            this.println("if (" + predictExit + ") break " + label + ";");
        }
        JavaBlockFinishingInfo howToFinish = this.genCommonBlock(blk, false);
        this.genBlockFinish(howToFinish, "break " + label + ";");
        --this.tabs;
        this.println("} while (true);");
        this.println("}");
        this.currentASTResult = saveCurrentASTResult;
    }

    @Override
    public void gen(LexerGrammar g) throws IOException {
        String suffix;
        String p;
        if (g.debuggingOutput) {
            this.semPreds = new Vector();
        }
        this.setGrammar(g);
        if (!(this.grammar instanceof LexerGrammar)) {
            this.antlrTool.fatalError("panic: Internal error generating lexer");
        }
        this.setupOutput(this.grammar.getClassName());
        this.genAST = false;
        this.saveText = true;
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.getHeaderAction(""));
        this.println("import java.io.InputStream;");
        this.println("import fuego.parser.TokenStreamException;");
        this.println("import fuego.parser.TokenStreamRecognitionException;");
        this.println("import fuego.parser.CharStreamException;");
        this.println("import fuego.parser.CharStreamIOException;");
        this.println("import fuego.parser.ANTLRException;");
        this.println("import java.io.Reader;");
        this.println("import java.util.Hashtable;");
        this.println("import java.util.Arrays;");
        this.println("import fuego.parser." + this.grammar.getSuperClass() + ";");
        this.println("import fuego.parser.InputBuffer;");
        this.println("import oracle.bpm.lang.Int;");
        this.println("import fuego.parser.ByteBuffer;");
        this.println("import fuego.parser.CharBuffer;");
        this.println("import fuego.parser.Token;");
        this.println("import fuego.parser.CommonToken;");
        this.println("import fuego.parser.RecognitionException;");
        this.println("import fuego.parser.NoViableAltForCharException;");
        this.println("import fuego.parser.MismatchedCharException;");
        this.println("import fuego.parser.TokenStream;");
        this.println("import fuego.parser.ANTLRHashString;");
        this.println("import fuego.parser.LexerSharedInputState;");
        this.println("import fuego.parser.collections.impl.BitSet;");
        this.println(this.grammar.preambleAction.getText());
        String sup = this.grammar.superClass != null ? this.grammar.superClass : "fuego.parser." + this.grammar.getSuperClass();
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        String prefix = "public";
        Token tprefix = this.grammar.options.get("classHeaderPrefix");
        if (tprefix != null && (p = Str.stripFrontBack(tprefix.getText(), "\"", "\"")) != null) {
            prefix = p;
        }
        this.print(prefix + " ");
        this.print("final class " + this.grammar.getClassName() + " extends " + sup);
        this.println(" implements " + this.grammar.tokenManager.getName() + TokenTypesFileSuffix + ", TokenStream");
        Token tsuffix = this.grammar.options.get("classHeaderSuffix");
        if (tsuffix != null && (suffix = Str.stripFrontBack(tsuffix.getText(), "\"", "\"")) != null) {
            this.print(", " + suffix);
        }
        this.println(" {");
        this.print(this.processActionForSpecialSymbols(this.grammar.classMemberAction.getText(), this.grammar.classMemberAction.getLine(), this.currentRule, null));
        this.println("public " + this.grammar.getClassName() + "(InputStream in) {");
        ++this.tabs;
        this.println("this(new ByteBuffer(in));");
        --this.tabs;
        this.println("}");
        this.println("public " + this.grammar.getClassName() + "(Reader in) {");
        ++this.tabs;
        this.println("this(new CharBuffer(in));");
        --this.tabs;
        this.println("}");
        this.println("public " + this.grammar.getClassName() + "(InputBuffer ib) {");
        ++this.tabs;
        if (this.grammar.debuggingOutput) {
            this.println("this(new LexerSharedInputState(new fuego.parser.debug.DebuggingInputBuffer(ib)));");
        } else {
            this.println("this(new LexerSharedInputState(ib));");
        }
        --this.tabs;
        this.println("}");
        this.println("public " + this.grammar.getClassName() + "(LexerSharedInputState state) {");
        ++this.tabs;
        this.println("super(state);");
        if (this.grammar.debuggingOutput) {
            this.println("  ruleNames  = _ruleNames;");
            this.println("  semPredNames = _semPredNames;");
            this.println("  setupDebugging();");
        }
        this.println("caseSensitiveLiterals = " + g.caseSensitiveLiterals + ";");
        this.println("setCaseSensitive(" + g.caseSensitive + ");");
        this.println("literals = new Hashtable();");
        for (String key : this.grammar.tokenManager.getTokenSymbolKeys()) {
            TokenSymbol tokenSymbol;
            if (key.charAt(0) != '\"' || !((tokenSymbol = this.grammar.tokenManager.getTokenSymbol(key)) instanceof StringLiteralSymbol)) continue;
            StringLiteralSymbol s = (StringLiteralSymbol)tokenSymbol;
            this.println("literals.put(new ANTLRHashString(" + s.getId() + ", this), " + s.getTokenType() + ");");
        }
        --this.tabs;
        this.println("}");
        if (this.grammar.debuggingOutput) {
            this.println("private static final String _ruleNames[] = {");
            for (RuleSymbol sym : this.grammar.rules) {
                this.println("  \"" + sym.getId() + "\",");
            }
            this.println("};");
        }
        this.genNextToken();
        int ruleNum = 0;
        for (RuleSymbol ruleSymbol : this.grammar.rules) {
            if (!"mnextToken".equals(ruleSymbol.getId())) {
                this.genRule(ruleSymbol, ruleNum++);
            }
            this.exitIfError();
        }
        if (this.grammar.debuggingOutput) {
            this.genSemPredMap();
        }
        this.genBitsets(this.bitsetsUsed, ((LexerGrammar)this.grammar).charVocabulary.size());
        this.println("");
        this.println("}");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    @Override
    public void gen(ParserGrammar g) throws IOException {
        String suffix;
        if (g.debuggingOutput) {
            this.semPreds = new Vector();
        }
        this.setGrammar(g);
        if (!(this.grammar instanceof ParserGrammar)) {
            this.antlrTool.fatalError("panic: Internal error generating parser");
        }
        this.setupOutput(this.grammar.getClassName());
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.getHeaderAction(""));
        this.println("import fuego.parser.TokenBuffer;");
        this.println("import fuego.parser.TokenStreamException;");
        this.println("import fuego.parser." + this.grammar.getSuperClass() + ";");
        this.println("import fuego.parser.Token;");
        this.println("import fuego.parser.TokenStream;");
        this.println("import fuego.parser.RecognitionException;");
        this.println("import fuego.parser.NoViableAltException;");
        this.println("import fuego.parser.ParserSharedInputState;");
        this.println("import fuego.parser.collections.impl.BitSet;");
        if (this.genAST) {
            this.println("import fuego.parser.collections.AST;");
        }
        this.println(this.grammar.preambleAction.getText());
        String sup = this.grammar.superClass != null ? this.grammar.superClass : "fuego.parser." + this.grammar.getSuperClass();
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.println("public class " + this.grammar.getClassName() + " extends " + sup);
        this.println("       implements " + this.grammar.tokenManager.getName() + TokenTypesFileSuffix);
        Token tsuffix = this.grammar.options.get("classHeaderSuffix");
        if (tsuffix != null && (suffix = Str.stripFrontBack(tsuffix.getText(), "\"", "\"")) != null) {
            this.print(", " + suffix);
        }
        this.println(" {");
        if (this.grammar.debuggingOutput) {
            this.println("private static final String _ruleNames[] = {");
            for (RuleSymbol sym : this.grammar.rules) {
                this.println("  \"" + sym.getId() + "\",");
            }
            this.println("};");
        }
        this.print(this.processActionForSpecialSymbols(this.grammar.classMemberAction.getText(), this.grammar.classMemberAction.getLine(), this.currentRule, null));
        this.println("");
        this.println("protected " + this.grammar.getClassName() + "(TokenBuffer tokenBuf, int k) {");
        this.println("  super(tokenBuf,k);");
        this.println("  tokenNames = _tokenNames;");
        if (this.grammar.debuggingOutput) {
            this.println("  ruleNames  = _ruleNames;");
            this.println("  semPredNames = _semPredNames;");
            this.println("  setupDebugging(tokenBuf);");
        }
        this.println("}");
        this.println("");
        this.println("public " + this.grammar.getClassName() + "(TokenBuffer tokenBuf) {");
        this.println("  this(tokenBuf," + this.grammar.maxk + ");");
        this.println("}");
        this.println("");
        this.println("protected " + this.grammar.getClassName() + "(TokenStream lexer, int k) {");
        this.println("  super(lexer,k);");
        this.println("  tokenNames = _tokenNames;");
        if (this.grammar.debuggingOutput) {
            this.println("  ruleNames  = _ruleNames;");
            this.println("  semPredNames = _semPredNames;");
            this.println("  setupDebugging(lexer);");
        }
        this.println("}");
        this.println("");
        this.println("public " + this.grammar.getClassName() + "(TokenStream lexer) {");
        this.println("  this(lexer," + this.grammar.maxk + ");");
        this.println("}");
        this.println("");
        this.println("public " + this.grammar.getClassName() + "(ParserSharedInputState state) {");
        this.println("  super(state," + this.grammar.maxk + ");");
        this.println("  tokenNames = _tokenNames;");
        this.println("}");
        this.println("");
        int ruleNum = 0;
        for (RuleSymbol sym : this.grammar.rules) {
            this.genRule(sym, ruleNum++);
            this.exitIfError();
        }
        if (this.grammar.inlineASTFactory) {
            this.generateMakeMethods();
        }
        if (this.genAST) {
            this.println("protected " + this.labeledElementASTType + " result = null;");
            this.println("public AST getAST() { return result; }");
        }
        this.genTokenStrings();
        this.genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
        if (this.grammar.debuggingOutput) {
            this.genSemPredMap();
        }
        this.println("");
        this.println("}");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    @Override
    public void gen(TreeWalkerGrammar g) throws IOException {
        String suffix;
        this.setGrammar(g);
        if (!(this.grammar instanceof TreeWalkerGrammar)) {
            this.antlrTool.fatalError("panic: Internal error generating tree-walker");
        }
        this.setupOutput(this.grammar.getClassName());
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.getHeaderAction(""));
        this.println("import fuego.parser." + this.grammar.getSuperClass() + ";");
        this.println("import fuego.parser.Token;");
        this.println("import fuego.parser.collections.AST;");
        this.println("import fuego.parser.RecognitionException;");
        this.println("import fuego.parser.NoViableAltException;");
        this.println("import fuego.parser.collections.impl.BitSet;");
        this.println("import fuego.parser.ASTPair;");
        this.println(this.grammar.preambleAction.getText());
        String sup = this.grammar.superClass != null ? this.grammar.superClass : "fuego.parser." + this.grammar.getSuperClass();
        this.println("");
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.println("public class " + this.grammar.getClassName() + " extends " + sup);
        this.println("       implements " + this.grammar.tokenManager.getName() + TokenTypesFileSuffix);
        Token tsuffix = this.grammar.options.get("classHeaderSuffix");
        if (tsuffix != null && (suffix = Str.stripFrontBack(tsuffix.getText(), "\"", "\"")) != null) {
            this.print(", " + suffix);
        }
        this.println(" {");
        this.print(this.processActionForSpecialSymbols(this.grammar.classMemberAction.getText(), this.grammar.classMemberAction.getLine(), this.currentRule, null));
        this.println("public " + this.grammar.getClassName() + "() {");
        ++this.tabs;
        this.println("tokenNames = _tokenNames;");
        --this.tabs;
        this.println("}");
        this.println("");
        int ruleNum = 0;
        for (RuleSymbol sym : this.grammar.rules) {
            this.genRule(sym, ruleNum++);
            this.exitIfError();
        }
        this.genTokenStrings();
        this.genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
        this.println("}");
        this.println("");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public JavaBlockFinishingInfo genCommonBlock(AlternativeBlock blk, boolean noTestForSingle) {
        int startDepth;
        JavaBlockFinishingInfo finishingInfo = new JavaBlockFinishingInfo();
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genCommonBlock(" + blk + ")");
        }
        boolean savegenAST = this.genAST;
        this.genAST = this.genAST && blk.getAutoGen();
        boolean oldsaveTest = this.saveText;
        boolean bl = this.saveText = this.saveText && blk.getAutoGen();
        if (blk.not && this.analyzer.subruleCanBeInverted(blk, this.grammar instanceof LexerGrammar)) {
            return this.generateForInverted(blk, finishingInfo);
        }
        if (blk.getAlternatives().size() == 1) {
            Alternative alt = blk.getAlternativeAt(0);
            if (alt.synPred != null) {
                this.antlrTool.warning("Syntactic predicate superfluous for single alternative", this.grammar.getFilename(), blk.getAlternativeAt((int)0).synPred.getLine(), blk.getAlternativeAt((int)0).synPred.getColumn());
            }
            if (noTestForSingle) {
                if (alt.semPred != null) {
                    this.genSemPred(alt.semPred, blk.line);
                }
                this.genAlt(alt, blk);
                return finishingInfo;
            }
        }
        int nLL1 = this.countLL1(blk);
        boolean createdLL1Switch = false;
        if (nLL1 >= this.makeSwitchThreshold) {
            String testExpr = this.lookaheadString(1);
            createdLL1Switch = true;
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("if (_t==null) _t=ASTNULL;");
            }
            this.println("switch ( " + testExpr + ") {");
            for (int i = 0; i < blk.alternatives.size(); ++i) {
                this.doAlternative(blk, i);
            }
            this.println("default:");
            ++this.tabs;
        }
        int closingBracesOfIFSequence = 0;
        int nIF = 0;
        for (int altDepth = startDepth = this.grammar instanceof LexerGrammar ? this.grammar.maxk : 0; altDepth >= 0; --altDepth) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("checking depth " + altDepth);
            }
            for (int i = 0; i < blk.alternatives.size(); ++i) {
                String e;
                boolean unpredicted;
                Alternative alt = blk.getAlternativeAt(i);
                if (this.DEBUG_CODE_GENERATOR) {
                    System.out.println("genAlt: " + i);
                }
                if (createdLL1Switch && JavaCodeGenerator.suitableForCaseExpression(alt)) {
                    if (!this.DEBUG_CODE_GENERATOR) continue;
                    System.out.println("ignoring alt because it was in the switch");
                    continue;
                }
                if (this.grammar instanceof LexerGrammar) {
                    int effectiveDepth = this.calculateEffectiveDepth(alt);
                    if (effectiveDepth != altDepth) {
                        if (!this.DEBUG_CODE_GENERATOR) continue;
                        System.out.println("ignoring alt because effectiveDepth!=altDepth;" + effectiveDepth + "!=" + altDepth);
                        continue;
                    }
                    unpredicted = this.lookaheadIsEmpty(alt, effectiveDepth);
                    e = this.getLookaheadTestExpression(alt, effectiveDepth);
                } else {
                    unpredicted = this.lookaheadIsEmpty(alt, this.grammar.maxk);
                    e = this.getLookaheadTestExpression(alt, this.grammar.maxk);
                }
                if (alt.cache[1].fset.degree() > 127 && JavaCodeGenerator.suitableForCaseExpression(alt)) {
                    if (nIF != 0) {
                        this.print("else ");
                    }
                    this.println("if " + e + " {");
                } else if (unpredicted && alt.semPred == null && alt.synPred == null) {
                    if (nIF != 0) {
                        this.print("else ");
                    }
                    this.println("{");
                    finishingInfo.needAnErrorClause = false;
                } else {
                    if (alt.semPred != null) {
                        e = this.wrapIfDebugging(alt, blk, e);
                    }
                    closingBracesOfIFSequence = this.generateSyntacticPredicates(nIF, alt, e, closingBracesOfIFSequence);
                }
                ++nIF;
                ++this.tabs;
                this.genAlt(alt, blk);
                --this.tabs;
                this.println("}");
            }
        }
        this.genAST = savegenAST;
        this.saveText = oldsaveTest;
        return this.returnFinishInfo(finishingInfo, closingBracesOfIFSequence, createdLL1Switch, nIF);
    }

    public void genNextToken() {
        boolean hasPublicRules = false;
        for (RuleSymbol rs : this.grammar.rules) {
            if (!rs.isDefined() || !"public".equals(rs.access)) continue;
            hasPublicRules = true;
            break;
        }
        if (!hasPublicRules) {
            this.println("");
            this.println("public Token nextToken() throws TokenStreamException {");
            this.println("\ttry {uponEOF();}");
            this.println("\tcatch(CharStreamIOException csioe) {");
            this.println("\t\tthrow new fuego.parser.TokenStreamIOException(csioe.io);");
            this.println("\t}");
            this.println("\tcatch(CharStreamException cse) {");
            this.println("\t\tthrow new fuego.paser.TokenStreamException(cse.getMessage());");
            this.println("\t}");
            this.println("\treturn new CommonToken(Token.EOF_TYPE, \"\");");
            this.println("}");
            this.println("");
            return;
        }
        RuleBlock nextTokenBlk = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
        RuleSymbol nextTokenRs = new RuleSymbol("mnextToken");
        nextTokenRs.setDefined();
        nextTokenRs.setBlock(nextTokenBlk);
        nextTokenRs.access = "private";
        this.grammar.define(nextTokenRs);
        this.grammar.theLLkAnalyzer.deterministic(nextTokenBlk);
        String filterRule = null;
        if (((LexerGrammar)this.grammar).filterMode) {
            filterRule = ((LexerGrammar)this.grammar).filterRule;
        }
        this.println("");
        this.println("public Token nextToken() throws TokenStreamException {");
        ++this.tabs;
        this.println("Token theRetToken=null;");
        this._println("tryAgain:");
        this.println("for (;;) {");
        ++this.tabs;
        this.println("Token _token = null;");
        this.println("int _ttype = Token.INVALID_TYPE;");
        if (((LexerGrammar)this.grammar).filterMode) {
            this.println("setCommitToPath(false);");
            if (filterRule != null) {
                if (!this.grammar.isDefined(CodeGenerator.encodeLexerRuleName(filterRule))) {
                    this.grammar.antlrTool.error("Filter rule " + filterRule + " does not exist in this lexer");
                } else {
                    RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(CodeGenerator.encodeLexerRuleName(filterRule));
                    if (!rs.isDefined()) {
                        this.grammar.antlrTool.error("Filter rule " + filterRule + " does not exist in this lexer");
                    } else if ("public".equals(rs.access)) {
                        this.grammar.antlrTool.error("Filter rule " + filterRule + " must be protected");
                    }
                }
                this.println("int _m;");
                this.println("_m = mark();");
            }
        }
        this.println("resetText();");
        this.println("try {   // for char stream error handling");
        ++this.tabs;
        this.println("try {   // for lexical error handling");
        ++this.tabs;
        for (int i = 0; i < nextTokenBlk.getAlternatives().size(); ++i) {
            Alternative a = nextTokenBlk.getAlternativeAt(i);
            if (!a.cache[1].containsEpsilon()) continue;
            RuleRefElement rr = (RuleRefElement)a.head;
            String r = CodeGenerator.decodeLexerRuleName(rr.targetRule);
            this.antlrTool.warning("public lexical rule " + r + " is optional (can match \"nothing\")");
        }
        String newline = System.getProperty("line.separator");
        JavaBlockFinishingInfo howToFinish = this.genCommonBlock(nextTokenBlk, false);
        String errFinish = "if (LA(1)==EOF_CHAR) {uponEOF(); _returnToken = makeToken(Token.EOF_TYPE);}";
        errFinish = errFinish + newline + "\t\t\t\t";
        errFinish = ((LexerGrammar)this.grammar).filterMode ? (filterRule == null ? errFinish + "else {consume(); continue tryAgain;}" : errFinish + "else {" + newline + "\t\t\t\t\tcommit();" + newline + "\t\t\t\t\ttry {m" + filterRule + "(false);}" + newline + "\t\t\t\t\tcatch(RecognitionException e) {" + newline + "\t\t\t\t\t // catastrophic failure" + newline + "\t\t\t\t\t reportError(e);" + newline + "\t\t\t\t\t consume();" + newline + "\t\t\t\t\t}" + newline + "\t\t\t\t\tcontinue tryAgain;" + newline + "\t\t\t\t}") : errFinish + "else {" + this.throwNoViable + "}";
        this.genBlockFinish(howToFinish, errFinish);
        if (((LexerGrammar)this.grammar).filterMode && filterRule != null) {
            this.println("commit();");
        }
        this.println("if ( _returnToken==null ) continue tryAgain; // found SKIP token");
        this.println("_ttype = _returnToken.getType();");
        if (((LexerGrammar)this.grammar).getTestLiterals()) {
            this.genLiteralsTest();
        }
        this.println("_returnToken.setType(_ttype);");
        this.println("return _returnToken;");
        --this.tabs;
        this.println("}");
        this.println("catch (RecognitionException e) {");
        ++this.tabs;
        if (((LexerGrammar)this.grammar).filterMode) {
            if (filterRule == null) {
                this.println("if ( !getCommitToPath() ) {consume(); continue tryAgain;}");
            } else {
                this.println("if ( !getCommitToPath() ) {");
                ++this.tabs;
                this.println("rewind(_m);");
                this.println("resetText();");
                this.println("try {m" + filterRule + "(false);}");
                this.println("catch(RecognitionException ee) {");
                this.println("       // horrendous failure: error in filter rule");
                this.println("       reportError(ee);");
                this.println("       consume();");
                this.println("}");
                this.println("continue tryAgain;");
                --this.tabs;
                this.println("}");
            }
        }
        if (nextTokenBlk.getDefaultErrorHandler()) {
            this.println("reportError(e);");
            this.println("consume();");
        } else {
            this.println("throw new TokenStreamRecognitionException(e);");
        }
        --this.tabs;
        this.println("}");
        --this.tabs;
        this.println("}");
        this.println("catch (CharStreamException cse) {");
        this.println("       if ( cse instanceof CharStreamIOException ) {");
        this.println("               throw new fuego.parser.TokenStreamIOException(((CharStreamIOException)cse).io);");
        this.println("       }");
        this.println("       else {");
        this.println("               throw new fuego.parser.TokenStreamException(cse.getMessage());");
        this.println("       }");
        this.println("}");
        --this.tabs;
        this.println("}");
        --this.tabs;
        this.println("}");
        this.println("");
    }

    public void genRule(RuleSymbol s, int ruleNum) {
        RuleBlock rblk;
        this.tabs = 1;
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRule(" + s.getId() + ")");
        }
        if (!s.isDefined()) {
            this.antlrTool.error("undefined rule: " + s.getId());
            return;
        }
        this.currentRule = rblk = s.getBlock();
        this.currentASTResult = s.getId();
        this.declaredASTVariables.clear();
        boolean savegenAST = this.genAST;
        this.genAST = this.genAST && rblk.getAutoGen();
        this.saveText = rblk.getAutoGen();
        if (s.comment != null) {
            this._println(s.comment);
        }
        this.print(s.access + " ");
        if (rblk.returnAction != null) {
            this._print(this.extractTypeOfAction(rblk.returnAction, rblk.getLine(), rblk.getColumn()) + " ");
        } else {
            this._print("void ");
        }
        this._print(s.getId() + "(");
        this._print(this.commonExtraParams);
        if (this.commonExtraParams.length() != 0 && rblk.argAction != null) {
            this._print(",");
        }
        if (rblk.argAction != null) {
            this._println("");
            ++this.tabs;
            this.println(rblk.argAction);
            --this.tabs;
            this.print(")");
        } else {
            this._print(")");
        }
        this._print(" throws " + this.exceptionThrown);
        if (this.grammar instanceof ParserGrammar) {
            this._print(", TokenStreamException");
        } else if (this.grammar instanceof LexerGrammar) {
            this._print(", CharStreamException, TokenStreamException");
        }
        if (rblk.throwsSpec != null) {
            if (this.grammar instanceof LexerGrammar) {
                this.antlrTool.error("user-defined throws spec not allowed (yet) for lexer rule " + rblk.ruleName);
            } else {
                this._print(", " + rblk.throwsSpec);
            }
        }
        this._println(" {");
        ++this.tabs;
        if (rblk.returnAction != null) {
            this.println(rblk.returnAction + ";");
        }
        this.println(this.commonLocalVars);
        if (this.grammar.traceRules) {
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("traceIn(\"" + s.getId() + "\",_t);");
            } else {
                this.println("traceIn(\"" + s.getId() + "\");");
            }
        }
        if (this.grammar instanceof LexerGrammar) {
            if ("mEOF".equals(s.getId())) {
                this.println("_ttype = Token.EOF_TYPE;");
            } else {
                this.println("_ttype = " + s.getId().substring(1) + ";");
            }
            this.println("int _saveIndex;");
        }
        if (this.grammar.debuggingOutput) {
            if (this.grammar instanceof ParserGrammar) {
                this.println("fireEnterRule(" + ruleNum + ",0);");
            } else if (this.grammar instanceof LexerGrammar) {
                this.println("fireEnterRule(" + ruleNum + ",_ttype);");
            }
        }
        if (this.grammar.debuggingOutput || this.grammar.traceRules) {
            this.println("try { // debugging");
            ++this.tabs;
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println(this.labeledElementASTType + " " + s.getId() + "_AST_in = (" + this.labeledElementASTType + ")_t;");
        }
        if (this.grammar.buildAST) {
            this.println("result = null;");
            if (this.grammar.inlineASTFactory) {
                this.println(this.labeledElementASTType + " root = null;");
                this.println(this.labeledElementASTType + " lastChild = null;");
            } else {
                this.println("ASTPair currentAST = new ASTPair();");
            }
            this.println(this.labeledElementASTType + " " + s.getId() + "_AST = null;");
        }
        this.genBlockPreamble(rblk);
        this.genBlockInitAction(rblk);
        this.println("");
        ExceptionSpec unlabeledUserSpec = rblk.findExceptionSpec("");
        if (unlabeledUserSpec != null || rblk.getDefaultErrorHandler()) {
            this.println("try {      // for error handling");
            ++this.tabs;
        }
        if (rblk.alternatives.size() == 1) {
            Alternative alt = rblk.getAlternativeAt(0);
            String pred = alt.semPred;
            if (pred != null) {
                this.genSemPred(pred, this.currentRule.line);
            }
            if (alt.synPred != null) {
                this.antlrTool.warning("Syntactic predicate ignored for single alternative", this.grammar.getFilename(), alt.synPred.getLine(), alt.synPred.getColumn());
            }
            this.genAlt(alt, rblk);
        } else {
            this.grammar.theLLkAnalyzer.deterministic(rblk);
            JavaBlockFinishingInfo howToFinish = this.genCommonBlock(rblk, false);
            this.genBlockFinish(howToFinish, this.getThrowNoViableAlt(s.getId()));
        }
        if (unlabeledUserSpec != null || rblk.getDefaultErrorHandler()) {
            --this.tabs;
            this.println("}");
        }
        if (unlabeledUserSpec != null) {
            this.genErrorHandler(unlabeledUserSpec);
        } else if (rblk.getDefaultErrorHandler()) {
            this.println("catch (" + this.exceptionThrown + " ex) {");
            ++this.tabs;
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if (inputState.guessing==0) {");
                ++this.tabs;
            }
            this.println("reportError(ex);");
            if (!(this.grammar instanceof TreeWalkerGrammar)) {
                Lookahead follow = this.grammar.theLLkAnalyzer.FOLLOW(1, rblk.endNode);
                String followSetName = this.getBitsetName(this.markBitsetForGen(follow.fset));
                this.println("consume();");
                this.println("consumeUntil(" + followSetName + ");");
            } else {
                this.println("if (_t!=null) {_t = _t.getNextSibling();}");
            }
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("} else {");
                this.println("  throw ex;");
                this.println("}");
            }
            --this.tabs;
            this.println("}");
        }
        if (this.grammar.buildAST) {
            this.println("result = " + s.getId() + "_AST;");
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_retTree = _t;");
        }
        if (rblk.getTestLiterals()) {
            if ("protected".equals(s.access)) {
                this.genLiteralsTestForPartialToken();
            } else {
                this.genLiteralsTest();
            }
        }
        if (this.grammar instanceof LexerGrammar) {
            this.println("if ( _createToken && _token==null && _ttype!=Token.SKIP ) {");
            this.println("   _token = makeToken(_ttype);");
            this.println("   _token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));");
            this.println("}");
            this.println("_returnToken = _token;");
        }
        if (rblk.returnAction != null) {
            this.println("return " + this.extractIdOfAction(rblk.returnAction, rblk.getLine(), rblk.getColumn()) + ";");
        }
        if (this.grammar.debuggingOutput || this.grammar.traceRules) {
            --this.tabs;
            this.println("} finally { // debugging");
            ++this.tabs;
            if (this.grammar.debuggingOutput) {
                if (this.grammar instanceof ParserGrammar) {
                    this.println("fireExitRule(" + ruleNum + ",0);");
                } else if (this.grammar instanceof LexerGrammar) {
                    this.println("fireExitRule(" + ruleNum + ",_ttype);");
                }
            }
            if (this.grammar.traceRules) {
                if (this.grammar instanceof TreeWalkerGrammar) {
                    this.println("traceOut(\"" + s.getId() + "\",_t);");
                } else {
                    this.println("traceOut(\"" + s.getId() + "\");");
                }
            }
            --this.tabs;
            this.println("}");
        }
        --this.tabs;
        this.println("}");
        this.println("");
        this.genAST = savegenAST;
    }

    public void genTokenStrings() {
        this.println("");
        this.println("public static final String[] _tokenNames = {");
        ++this.tabs;
        Vector v = this.grammar.tokenManager.getVocabulary();
        for (int i = 0; i < v.size(); ++i) {
            TokenSymbol ts;
            String s = (String)v.elementAt(i);
            if (s == null) {
                s = "<" + String.valueOf(i) + ">";
            }
            if (!s.startsWith("\"") && !s.startsWith("<") && (ts = this.grammar.tokenManager.getTokenSymbol(s)) != null && ts.getParaphrase() != null) {
                s = Str.stripFrontBack(ts.getParaphrase(), "\"", "\"");
            }
            this.print(this.charFormatter.literalString(s));
            if (i != v.size() - 1) {
                this._print(",");
            }
            this._println("");
        }
        --this.tabs;
        this.println("};");
    }

    @Override
    public String mapTreeId(String idParam, ActionTransInfo transInfo) {
        if (this.currentRule == null) {
            return idParam;
        }
        boolean in_var = false;
        String id = idParam;
        if (this.grammar instanceof TreeWalkerGrammar) {
            if (!this.grammar.buildAST) {
                in_var = true;
            } else if (id.length() > 3 && id.lastIndexOf("_in") == id.length() - 3) {
                id = id.substring(0, id.length() - 3);
                in_var = true;
            }
        }
        for (int i = 0; i < this.currentRule.labeledElements.size(); ++i) {
            AlternativeElement elt = this.currentRule.labeledElements.elementAt(i);
            if (!elt.getLabel().equals(id)) continue;
            return in_var ? id : id + "_AST";
        }
        String s = this.treeVariableMap.get(id);
        if (s != null) {
            if (NONUNIQUE.equals(s)) {
                this.antlrTool.error("Ambiguous reference to AST element " + id + " in rule " + this.currentRule.getRuleName());
                return null;
            }
            if (s.equals(this.currentRule.getRuleName())) {
                this.antlrTool.error("Ambiguous reference to AST element " + id + " in rule " + this.currentRule.getRuleName());
                return null;
            }
            return in_var ? s + "_in" : s;
        }
        if (id.equals(this.currentRule.getRuleName())) {
            String r;
            String string = r = in_var ? id + "_AST_in" : id + "_AST";
            if (transInfo != null && !in_var) {
                transInfo.refRuleRoot = r;
            }
            return r;
        }
        return id;
    }

    public void setupOutput(String className) throws IOException {
        this.currentOutput = this.antlrTool.openOutputFile(className + ".java");
    }

    protected String getLookaheadTestExpression(Lookahead[] look, int k) {
        StringBuilder e = new StringBuilder(100);
        e.append("(");
        boolean first = true;
        for (int i = 1; i <= k; ++i) {
            BitSet p = look[i].fset;
            if (!first) {
                e.append(") && (");
            }
            first = false;
            if (look[i].containsEpsilon()) {
                e.append("true");
                continue;
            }
            e.append(this.getLookaheadTestTerm(i, p));
        }
        e.append(")");
        return e.toString();
    }

    protected String getLookaheadTestExpression(Alternative alt, int maxDepth) {
        int depth = alt.lookaheadDepth;
        if (depth == Integer.MAX_VALUE) {
            depth = this.grammar.maxk;
        }
        if (maxDepth == 0) {
            return "( true )";
        }
        return "(" + this.getLookaheadTestExpression(alt.cache, depth) + ")";
    }

    protected String getLookaheadTestTerm(int k, BitSet p) {
        String ts = this.lookaheadString(k);
        int[] elems = p.toArray();
        if (JavaCodeGenerator.elementsAreRange(elems)) {
            return this.getRangeExpression(k, elems);
        }
        int degree = p.degree();
        if (degree == 0) {
            return "true";
        }
        if (degree >= this.bitsetTestThreshold) {
            int bitsetIdx = this.markBitsetForGen(p);
            return this.getBitsetName(bitsetIdx) + ".member(" + ts + ")";
        }
        StringBuilder e = new StringBuilder();
        for (int i = 0; i < elems.length; ++i) {
            String cs = this.getValueString(elems[i]);
            if (i > 0) {
                e.append("||");
            }
            e.append(ts);
            e.append("==");
            e.append(cs);
        }
        return e.toString();
    }

    protected int addSemPred(String predicate) {
        this.semPreds.appendElement(predicate);
        return this.semPreds.size() - 1;
    }

    protected void genASTDeclaration(AlternativeElement el) {
        this.genASTDeclaration(el, this.labeledElementASTType);
    }

    protected void genASTDeclaration(AlternativeElement el, String node_type) {
        this.genASTDeclaration(el, el.getLabel(), node_type);
    }

    protected void genASTDeclaration(AlternativeElement el, String var_name, String node_type) {
        if (this.declaredASTVariables.contains(el)) {
            return;
        }
        this.println(node_type + " " + var_name + "_AST = null;");
        this.declaredASTVariables.add(el);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void genAlt(Alternative alt, AlternativeBlock blk) {
        boolean savegenAST = this.genAST;
        this.genAST = this.genAST && alt.getAutoGen();
        boolean oldsaveTest = this.saveText;
        this.saveText = this.saveText && alt.getAutoGen();
        Hashtable<String, String> saveMap = this.treeVariableMap;
        this.treeVariableMap = new Hashtable();
        if (alt.exceptionSpec != null) {
            this.println("try {      // for error handling");
            ++this.tabs;
        }
        AlternativeElement elem = alt.head;
        while (!(elem instanceof BlockEndElement)) {
            elem.generate();
            elem = elem.next;
        }
        if (this.genAST) {
            if (blk instanceof RuleBlock) {
                RuleBlock rblk = (RuleBlock)blk;
                if (this.grammar.hasSyntacticPredicate) {
                    // empty if block
                }
                this.print(rblk.getRuleName() + "_AST = " + this.getRootReference() + ";");
                if (!this.grammar.hasSyntacticPredicate) {
                    // empty if block
                }
            } else if (blk.getLabel() != null) {
                this.antlrTool.warning("Labeled subrules not yet supported", this.grammar.getFilename(), blk.getLine(), blk.getColumn());
            }
        }
        if (alt.exceptionSpec != null) {
            --this.tabs;
            this.println("}");
            this.genErrorHandler(alt.exceptionSpec);
        }
        this.genAST = savegenAST;
        this.saveText = oldsaveTest;
        this.treeVariableMap = saveMap;
    }

    protected void genBitsets(Vector bitsetList, int maxVocabulary) {
        this.println("");
        for (int i = 0; i < bitsetList.size(); ++i) {
            BitSet p = (BitSet)bitsetList.elementAt(i);
            p.growToInclude(maxVocabulary);
            this.genBitSet(p, i);
        }
    }

    protected void genBlockInitAction(AlternativeBlock blk) {
        if (blk.initAction != null) {
            this.printAction(this.processActionForSpecialSymbols(blk.initAction, blk.getLine(), this.currentRule, null));
        }
    }

    protected void genBlockPreamble(AlternativeBlock blk) {
        if (blk instanceof RuleBlock) {
            RuleBlock block = (RuleBlock)blk;
            if (block.labeledElements != null) {
                this.genBlockPreamble(block);
            }
        }
    }

    protected void genCases(BitSet p) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genCases(" + p + ")");
        }
        int[] elems = p.toArray();
        int wrap = this.grammar instanceof LexerGrammar ? 4 : 1;
        int j = 1;
        boolean startOfLine = true;
        for (int elem : elems) {
            if (j == 1) {
                this.print("");
            } else {
                this._print("  ");
            }
            this._print("case " + this.getValueString(elem) + ":");
            if (j == wrap) {
                this._println("");
                startOfLine = true;
                j = 1;
                continue;
            }
            ++j;
            startOfLine = false;
        }
        if (!startOfLine) {
            this._println("");
        }
    }

    protected void genHeader() {
        this.println("// $ANTLR " + Tool.version + ": " + "\"" + this.antlrTool.fileMinusPath(this.antlrTool.grammarFile) + "\"" + " -> " + "\"" + this.grammar.getClassName() + ".java\"$");
    }

    protected void genMatch() {
    }

    protected void genMatch(GrammarAtom atom) {
        if (atom instanceof StringLiteralElement) {
            if (this.grammar instanceof LexerGrammar) {
                this.genMatchUsingAtomText(atom);
            } else {
                this.genMatchUsingAtomTokenType(atom);
            }
        } else if (atom instanceof CharLiteralElement) {
            if (this.grammar instanceof LexerGrammar) {
                this.genMatchUsingAtomText(atom);
            } else {
                this.antlrTool.error("cannot ref character literals in grammar: " + atom);
            }
        } else if (atom instanceof TokenRefElement) {
            this.genMatchUsingAtomText(atom);
        } else if (atom instanceof WildcardElement) {
            this.gen((WildcardElement)atom);
        }
    }

    protected void genMatchUsingAtomText(GrammarAtom atom) {
        String astArgs = "";
        if (this.grammar instanceof TreeWalkerGrammar) {
            astArgs = "_t,";
        }
        if (this.grammar instanceof LexerGrammar && (!this.saveText || atom.getAutoGenType() == 3)) {
            this.println("_saveIndex=text.length();");
        }
        this.print(atom.not ? "matchNot(" : "match(");
        this._print(astArgs);
        if ("EOF".equals(atom.atomText)) {
            this._print("Token.EOF_TYPE");
        } else {
            this._print(atom.atomText);
        }
        this._println(");");
        if (this.grammar instanceof LexerGrammar && (!this.saveText || atom.getAutoGenType() == 3)) {
            this.println("text.setLength(_saveIndex);");
        }
    }

    protected void genMatchUsingAtomTokenType(GrammarAtom atom) {
        String astArgs = "";
        if (this.grammar instanceof TreeWalkerGrammar) {
            astArgs = "_t,";
        }
        String s = astArgs + this.getValueString(atom.getType());
        this.println((atom.not ? "matchNot(" : "match(") + s + ");");
    }

    protected void genSemPred(String pred, int line) {
        ActionTransInfo tInfo = new ActionTransInfo();
        pred = this.processActionForSpecialSymbols(pred, line, this.currentRule, tInfo);
        String escapedPred = this.charFormatter.escapeString(pred);
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            pred = "fireSemanticPredicateEvaluated(fuego.parser.debug.SemanticPredicateEvent.VALIDATING," + this.addSemPred(escapedPred) + "," + pred + ")";
        }
        this.println("if (!(" + pred + "))");
        this.println("  throw new fuego.parser.SemanticException(\"" + escapedPred + "\");");
    }

    protected void genSemPredMap() {
        this.println("private String _semPredNames[] = {");
        for (String pred : this.semPreds) {
            this.println("\"" + pred + "\",");
        }
        this.println("};");
    }

    protected void genSynPred(SynPredBlock blk, String lookaheadExpr) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen=>(" + blk + ")");
        }
        this.println("boolean synPredMatched" + blk.ID + " = false;");
        this.println("if (" + lookaheadExpr + ") {");
        ++this.tabs;
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("AST __t" + blk.ID + " = _t;");
        } else {
            this.println("int _m" + blk.ID + " = mark();");
        }
        this.println("synPredMatched" + blk.ID + " = true;");
        this.println("inputState.guessing++;");
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            this.println("fireSyntacticPredicateStarted();");
        }
        ++this.syntacticPredLevel;
        this.println("try {");
        ++this.tabs;
        this.gen(blk);
        --this.tabs;
        this.println("}");
        this.println("catch (" + this.exceptionThrown + " pe) {");
        ++this.tabs;
        this.println("synPredMatched" + blk.ID + " = false;");
        --this.tabs;
        this.println("}");
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = __t" + blk.ID + ";");
        } else {
            this.println("rewind(_m" + blk.ID + ");");
        }
        this.println("inputState.guessing--;");
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            this.println("if (synPredMatched" + blk.ID + ")");
            this.println("  fireSyntacticPredicateSucceeded();");
            this.println("else");
            this.println("  fireSyntacticPredicateFailed();");
        }
        --this.syntacticPredLevel;
        --this.tabs;
        this.println("}");
        this.println("if ( synPredMatched" + blk.ID + " ) {");
    }

    protected void genTokenTypes(TokenManager tm) throws IOException {
        this.setupOutput(tm.getName() + TokenTypesFileSuffix);
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.getHeaderAction(""));
        this.println("public interface " + tm.getName() + TokenTypesFileSuffix + " {");
        ++this.tabs;
        Vector v = tm.getVocabulary();
        this.println("int EOF = 1;");
        this.println("int NULL_TREE_LOOKAHEAD = 3;");
        for (int i = 4; i < v.size(); ++i) {
            String s = (String)v.elementAt(i);
            if (s == null) continue;
            if (s.startsWith("\"")) {
                StringLiteralSymbol sl = (StringLiteralSymbol)tm.getTokenSymbol(s);
                if (sl == null) {
                    this.antlrTool.fatalError("panic: String literal " + s + " not in symbol table");
                    continue;
                }
                if (sl.label != null) {
                    this.println("int " + sl.label + " = " + i + ";");
                    continue;
                }
                String mangledName = this.mangleLiteral(s);
                if (mangledName != null) {
                    this.println("int " + mangledName + " = " + i + ";");
                    sl.label = mangledName;
                    continue;
                }
                this.println("// " + s + " = " + i);
                continue;
            }
            if (s.startsWith("<")) continue;
            this.println("int " + s + " = " + i + ";");
        }
        --this.tabs;
        this.println("}");
        this.currentOutput.close();
        this.currentOutput = null;
        this.exitIfError();
    }

    protected boolean lookaheadIsEmpty(Alternative alt, int maxDepth) {
        int depth = alt.lookaheadDepth;
        if (depth == Integer.MAX_VALUE) {
            depth = this.grammar.maxk;
        }
        for (int i = 1; i <= depth && i <= maxDepth; ++i) {
            BitSet p = alt.cache[i].fset;
            if (p.degree() == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String processActionForSpecialSymbols(String actionStr, int line, RuleBlock current, ActionTransInfo tInfo) {
        if (actionStr == null || actionStr.length() == 0) {
            return null;
        }
        if (this.grammar == null) {
            return actionStr;
        }
        if (this.grammar.buildAST && actionStr.indexOf(35) != -1 || this.grammar instanceof TreeWalkerGrammar || (this.grammar instanceof LexerGrammar || this.grammar instanceof ParserGrammar) && actionStr.indexOf(36) != -1) {
            ActionLexer lexer = new ActionLexer(actionStr, current, this, tInfo);
            lexer.setLineOffset(line);
            lexer.setFilename(this.grammar.getFilename());
            lexer.setTool(this.antlrTool);
            try {
                lexer.mACTION(true);
                actionStr = lexer.getTokenObject().getText();
            }
            catch (RecognitionException ex) {
                lexer.reportError(ex);
                return actionStr;
            }
            catch (TokenStreamException tex) {
                this.antlrTool.fatalError("panic: Error reading action:" + actionStr);
                return actionStr;
            }
            catch (CharStreamException io) {
                this.antlrTool.fatalError("panic: Error reading action:" + actionStr);
                return actionStr;
            }
        }
        return actionStr;
    }

    private static boolean suitableForCaseExpression(Alternative a) {
        return a.lookaheadDepth == 1 && a.semPred == null && !a.cache[1].containsEpsilon() && a.cache[1].fset.degree() <= 127;
    }

    private JavaBlockFinishingInfo returnFinishInfo(JavaBlockFinishingInfo finishingInfo, int closingBracesOfIFSequence, boolean createdLL1Switch, int nIF) {
        StringBuffer ps = this.closingIfs(closingBracesOfIFSequence);
        if (createdLL1Switch) {
            --this.tabs;
            finishingInfo.postscript = ps.append("}").toString();
            finishingInfo.generatedSwitch = true;
        } else {
            finishingInfo.postscript = ps.toString();
            finishingInfo.generatedSwitch = false;
        }
        finishingInfo.generatedAnIf = nIF > 0;
        return finishingInfo;
    }

    private StringBuffer closingIfs(int closingBracesOfIFSequence) {
        StringBuffer ps = new StringBuffer();
        for (int i = 1; i <= closingBracesOfIFSequence; ++i) {
            ps.append("}");
        }
        return ps;
    }

    private String wrapIfDebugging(Alternative alt, AlternativeBlock blk, String e) {
        ActionTransInfo tInfo = new ActionTransInfo();
        String actionStr = this.processActionForSpecialSymbols(alt.semPred, blk.line, this.currentRule, tInfo);
        e = (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar) && this.grammar.debuggingOutput ? "(" + e + "&& fireSemanticPredicateEvaluated(fuego.parser.debug.SemanticPredicateEvent.PREDICTING," + this.addSemPred(this.charFormatter.escapeString(actionStr)) + "," + actionStr + "))" : "(" + e + "&&(" + actionStr + "))";
        return e;
    }

    private int generateSyntacticPredicates(int nIF, Alternative alt, String e, int closingBracesOfIFSequence) {
        if (nIF > 0) {
            if (alt.synPred != null) {
                this.println("else {");
                ++this.tabs;
                this.genSynPred(alt.synPred, e);
                ++closingBracesOfIFSequence;
            } else {
                this.println("else if " + e + " {");
            }
        } else if (alt.synPred != null) {
            this.genSynPred(alt.synPred, e);
        } else {
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("if (_t==null) _t=ASTNULL;");
            }
            this.println("if " + e + " {");
        }
        return closingBracesOfIFSequence;
    }

    private int calculateEffectiveDepth(Alternative alt) {
        int effectiveDepth = alt.lookaheadDepth;
        if (effectiveDepth == Integer.MAX_VALUE) {
            effectiveDepth = this.grammar.maxk;
        }
        while (effectiveDepth >= 1 && alt.cache[effectiveDepth].containsEpsilon()) {
            --effectiveDepth;
        }
        return effectiveDepth;
    }

    private void doAlternative(AlternativeBlock blk, int i) {
        Alternative alt = blk.getAlternativeAt(i);
        if (JavaCodeGenerator.suitableForCaseExpression(alt)) {
            Lookahead p = alt.cache[1];
            if (p.fset.degree() == 0 && !p.containsEpsilon()) {
                this.antlrTool.warning("Alternate omitted due to empty prediction set", this.grammar.getFilename(), alt.head.getLine(), alt.head.getColumn());
            } else {
                this.genCases(p.fset);
                this.println("{");
                ++this.tabs;
                this.genAlt(alt, blk);
                this.println("break;");
                --this.tabs;
                this.println("}");
            }
        }
    }

    private void genBlockPreamble(RuleBlock block) {
        for (int i = 0; i < block.labeledElements.size(); ++i) {
            AlternativeElement a = block.labeledElements.elementAt(i);
            this.genBlockPreamble(a);
        }
    }

    private void genBlockPreamble(AlternativeElement alternative) {
        boolean isRuleRef = alternative instanceof RuleRefElement;
        if (isRuleRef || alternative instanceof AlternativeBlock && !(alternative instanceof RuleBlock) && !(alternative instanceof SynPredBlock)) {
            if (!isRuleRef && ((AlternativeBlock)alternative).not && this.analyzer.subruleCanBeInverted((AlternativeBlock)alternative, this.grammar instanceof LexerGrammar)) {
                this.println(this.labeledElementType + " " + alternative.getLabel() + " = " + this.labeledElementInit + ";");
                if (this.grammar.buildAST) {
                    this.genASTDeclaration(alternative);
                }
            } else {
                if (this.grammar.buildAST) {
                    this.genASTDeclaration(alternative);
                }
                if (this.grammar instanceof LexerGrammar) {
                    this.println("Token " + alternative.getLabel() + "=null;");
                }
                if (this.grammar instanceof TreeWalkerGrammar) {
                    this.println(this.labeledElementType + " " + alternative.getLabel() + " = " + this.labeledElementInit + ";");
                }
            }
        } else {
            this.println(this.labeledElementType + " " + alternative.getLabel() + " = " + this.labeledElementInit + ";");
            if (this.grammar.buildAST) {
                if (alternative instanceof GrammarAtom && ((GrammarAtom)alternative).getASTNodeType() != null) {
                    GrammarAtom ga = (GrammarAtom)alternative;
                    this.genASTDeclaration(alternative, ga.getASTNodeType());
                } else {
                    this.genASTDeclaration(alternative);
                }
            }
        }
    }

    private void generateTokens(Iterator iterator) throws IOException {
        TokenManager tm = (TokenManager)iterator.next();
        if (!tm.isReadOnly()) {
            this.genTokenTypes(tm);
            this.genTokenInterchange(tm);
        }
        this.exitIfError();
    }

    private void generateGrammar(Grammar g) throws IOException {
        g.setGrammarAnalyzer(this.analyzer);
        g.setCodeGenerator(this);
        this.analyzer.setGrammar(g);
        this.setupGrammarParameters(g);
        g.generate();
        this.exitIfError();
    }

    private void manageAssignToRoot(ActionTransInfo tInfo) {
        if (tInfo.assignToRoot) {
            this.println(this.getRootReference() + " = " + tInfo.refRuleRoot + ";");
            this.println(this.getLastChildReference() + " = " + tInfo.refRuleRoot + " !=null && " + tInfo.refRuleRoot + ".getFirstChild()!=null ?");
            ++this.tabs;
            this.println("(" + this.labeledElementASTType + ") " + tInfo.refRuleRoot + ".getFirstChild() : " + tInfo.refRuleRoot + ";");
            --this.tabs;
            if (this.grammar.inlineASTFactory) {
                this.println("lastChild = lastChild != null ? (" + this.labeledElementASTType + ") lastChild.getLastSibling() : lastChild;");
            } else {
                this.println("currentAST.advanceChildToEnd();");
            }
        }
    }

    private void genNotInSyntaticPredicate(RuleRefElement rr) {
        boolean doNoGuessTest;
        boolean bl = doNoGuessTest = this.grammar.hasSyntacticPredicate && (this.grammar.buildAST && rr.getLabel() != null || this.genAST && rr.getAutoGenType() == 1);
        if (doNoGuessTest) {
            // empty if block
        }
        if (this.grammar.buildAST && rr.getLabel() != null) {
            this.println(rr.getLabel() + "_AST = result;");
        }
        if (this.genAST) {
            switch (rr.getAutoGenType()) {
                case 1: {
                    if (this.grammar.inlineASTFactory) {
                        this.generateAddASTChild("result");
                        break;
                    }
                    this.println("astFactory.addASTChild(currentAST, result);");
                    break;
                }
                case 2: {
                    this.antlrTool.error("Internal: encountered ^ after rule reference");
                    break;
                }
            }
        }
        if (this.grammar instanceof LexerGrammar && rr.getLabel() != null) {
            this.println(rr.getLabel() + "=_returnToken;");
        }
        if (doNoGuessTest) {
            // empty if block
        }
    }

    private int countLL1(AlternativeBlock blk) {
        int nLL1 = 0;
        for (int i = 0; i < blk.getAlternatives().size(); ++i) {
            Alternative a = blk.getAlternativeAt(i);
            if (!JavaCodeGenerator.suitableForCaseExpression(a)) continue;
            ++nLL1;
        }
        return nLL1;
    }

    private JavaBlockFinishingInfo generateForInverted(AlternativeBlock blk, JavaBlockFinishingInfo finishingInfo) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("special case: ~(subrule)");
        }
        Lookahead p = this.analyzer.look(1, blk);
        if (blk.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(blk.getLabel() + " = " + this.lt1Value + ";");
        }
        this.genElementAST(blk);
        String astArgs = "";
        if (this.grammar instanceof TreeWalkerGrammar) {
            astArgs = "_t,";
        }
        this.println("match(" + astArgs + this.getBitsetName(this.markBitsetForGen(p.fset)) + ");");
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t.getNextSibling();");
        }
        return finishingInfo;
    }

    private String getLastChildReference() {
        if (this.grammar.inlineASTFactory) {
            return "lastChild";
        }
        return "currentAST.child";
    }

    private String getRootReference() {
        if (this.grammar.inlineASTFactory) {
            return "root";
        }
        return "currentAST.root";
    }

    private String getThrowNoViableAlt(String rule) {
        if (!this.genAST) {
            return this.throwNoViable;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.labeledElementASTType);
        buffer.append(" node = ");
        buffer.append("(").append(this.labeledElementASTType).append(")");
        buffer.append(" noViableAlt(LT(1), getFilename(), ");
        String result = "root";
        if (rule != null) {
            buffer.append("\"").append(rule).append("\"");
            result = rule + "_AST";
        } else {
            buffer.append("null");
        }
        buffer.append(");");
        buffer.append(" ");
        buffer.append(result);
        buffer.append(" = ");
        buffer.append(result);
        buffer.append(" != null ? ");
        buffer.append(result);
        buffer.append(" : node;");
        return buffer.toString();
    }

    private String getValueString(int value) {
        String cs;
        if (this.grammar instanceof LexerGrammar) {
            cs = this.charFormatter.literalChar(value);
        } else {
            TokenSymbol ts = this.grammar.tokenManager.getTokenSymbolAt(value);
            if (ts == null) {
                return "" + value;
            }
            String tId = ts.getId();
            if (ts instanceof StringLiteralSymbol) {
                StringLiteralSymbol sl = (StringLiteralSymbol)ts;
                String label = sl.getLabel();
                if (label != null) {
                    cs = label;
                } else {
                    cs = this.mangleLiteral(tId);
                    if (cs == null) {
                        cs = String.valueOf(value);
                    }
                }
            } else {
                cs = tId;
            }
        }
        return cs;
    }

    private void GenRuleInvocation(RuleRefElement rr) {
        this._print(rr.targetRule + "(");
        if (this.grammar instanceof LexerGrammar) {
            if (rr.getLabel() != null) {
                this._print("true");
            } else {
                this._print("false");
            }
            if (this.commonExtraArgs.length() != 0 || rr.args != null) {
                this._print(",");
            }
        }
        this._print(this.commonExtraArgs);
        if (this.commonExtraArgs.length() != 0 && rr.args != null) {
            this._print(",");
        }
        RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(rr.targetRule);
        if (rr.args != null) {
            ActionTransInfo tInfo = new ActionTransInfo();
            String args = this.processActionForSpecialSymbols(rr.args, 0, this.currentRule, tInfo);
            if (tInfo.assignToRoot || tInfo.refRuleRoot != null) {
                this.antlrTool.error("Arguments of rule reference '" + rr.targetRule + "' cannot set or ref #" + this.currentRule.getRuleName(), this.grammar.getFilename(), rr.getLine(), rr.getColumn());
            }
            this._print(args);
            if (rs.block.argAction == null) {
                this.antlrTool.warning("Rule '" + rr.targetRule + "' accepts no arguments", this.grammar.getFilename(), rr.getLine(), rr.getColumn());
            }
        } else if (rs.block.argAction != null) {
            this.antlrTool.warning("Missing parameters on reference to rule " + rr.targetRule, this.grammar.getFilename(), rr.getLine(), rr.getColumn());
        }
        this._println(");");
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _retTree;");
        }
    }

    private void genJavaDoc(BitSet p) {
        StringBuilder sb = new StringBuilder(150);
        this.println("/**");
        int i = p.next(-1);
        int first = -100;
        while (i >= 0) {
            int next = p.next(i);
            if (first < 0) {
                first = i;
                sb.append(sb.length() == 0 ? " * " : ", ").append(first);
            }
            if (i + 1 != next) {
                if (i != first) {
                    sb.append(i > first + 1 ? ".." : ", ").append(i);
                }
                if (sb.length() > 100 || next < 0) {
                    this.println(sb.toString());
                    sb.setLength(0);
                }
                first = -100;
            }
            i = next;
        }
        this.println(" */");
    }

    private void genBitSet(BitSet p, int id) {
        p = p.packed();
        this.println("");
        this.genJavaDoc(p);
        this.println("public final BitSet " + this.getBitsetName(id) + " = " + JavaCodeGenerator.bitSetGen(p) + ';');
    }

    private void genBlockFinish(JavaBlockFinishingInfo howToFinish, String noViableAction) {
        if (howToFinish.needAnErrorClause && (howToFinish.generatedAnIf || howToFinish.generatedSwitch)) {
            if (howToFinish.generatedAnIf) {
                this.println("else {");
            } else {
                this.println("{");
            }
            ++this.tabs;
            this.println(noViableAction);
            --this.tabs;
            this.println("}");
        }
        if (howToFinish.postscript != null) {
            this.println(howToFinish.postscript);
        }
    }

    private void genErrorHandler(ExceptionSpec ex) {
        for (int i = 0; i < ex.handlers.size(); ++i) {
            ExceptionHandler handler = ex.handlers.elementAt(i);
            this.println("catch (" + handler.exceptionTypeAndName.getText() + ") {");
            ++this.tabs;
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if (inputState.guessing==0) {");
                ++this.tabs;
            }
            ActionTransInfo tInfo = new ActionTransInfo();
            this.printAction(this.processActionForSpecialSymbols(handler.action.getText(), handler.action.getLine(), this.currentRule, tInfo));
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("} else {");
                ++this.tabs;
                this.println("throw " + this.extractIdOfAction(handler.exceptionTypeAndName) + ";");
                --this.tabs;
                this.println("}");
            }
            --this.tabs;
            this.println("}");
        }
    }

    private void genErrorTryForElement(AlternativeElement el) {
        RuleSymbol rs;
        if (el.getLabel() == null) {
            return;
        }
        String r = el.enclosingRuleName;
        if (this.grammar instanceof LexerGrammar) {
            r = CodeGenerator.encodeLexerRuleName(el.enclosingRuleName);
        }
        if ((rs = (RuleSymbol)this.grammar.getSymbol(r)) == null) {
            this.antlrTool.fatalError("panic: Enclosing rule not found!");
            return;
        }
        ExceptionSpec ex = rs.block.findExceptionSpec(el.getLabel());
        if (ex != null) {
            this.println("try { // for error handling");
            ++this.tabs;
        }
    }

    private void genLiteralsTest() {
        this.println("_ttype = testLiteralsTable(_ttype);");
    }

    private void genLiteralsTestForPartialToken() {
        this.println("_ttype = testLiteralsTable(new String(text.getBuffer(),_begin,text.length()-_begin),_ttype);");
    }

    private void generateAddASTChild(String child) {
        this.println("if (root == null) {");
        this.printIndentedLn("root = " + child + ";");
        this.println("}");
        this.println("else {");
        ++this.tabs;
        this.println("if (lastChild == null) {");
        this.printIndentedLn("root.setFirstChild(" + child + ");");
        this.println("}");
        this.println("else {");
        this.printIndentedLn("lastChild.setNextSibling(" + child + ");");
        this.println("}");
        --this.tabs;
        this.println("}");
        this.println("lastChild = " + child + " != null ? (" + this.labeledElementASTType + ") " + child + ".getLastSibling() : lastChild;");
    }

    private void generateMakeMethod(int length) {
        int j;
        this.currentOutput.println();
        this.print("public static " + this.labeledElementASTType + " make(");
        for (j = 0; j < length; ++j) {
            this.currentOutput.print(this.labeledElementASTType + " ast" + j);
            if (j + 1 >= length) continue;
            this.currentOutput.print(", ");
        }
        this.currentOutput.println(") {");
        ++this.tabs;
        this.println(this.labeledElementASTType + " root = ast0;");
        this.println(this.labeledElementASTType + " tail = null;");
        for (j = 1; j < length; ++j) {
            String ast = "ast" + j;
            this.println("if (" + ast + " != null) {");
            this.printIndentedLn("if (root == null) { root = " + ast + "; }");
            this.printIndentedLn("else if (tail == null) { root.setFirstChild(" + ast + "); }");
            this.printIndentedLn("else { tail.setNextSibling(" + ast + "); }");
            if (j + 1 < length) {
                this.printIndentedLn("tail = " + ast + " != null ? (" + this.labeledElementASTType + ")" + ast + ".getLastSibling() : null;");
            }
            this.println("}");
        }
        this.println("return root;");
        --this.tabs;
        this.println("}");
    }

    private void generateMakeMethods() {
        Iterator<Integer> i$ = this.grammar.makeArrayLengths.iterator();
        while (i$.hasNext()) {
            Integer makeArrayLength;
            Integer length = makeArrayLength = i$.next();
            this.generateMakeMethod(length);
        }
    }

    private void genElementAST(AlternativeElement el) {
        if (this.grammar instanceof TreeWalkerGrammar && !this.grammar.buildAST) {
            if (el.getLabel() == null) {
                String elementRef = this.lt1Value;
                String astName = "tmp" + this.astVarNumber + "_AST";
                ++this.astVarNumber;
                this.mapTreeVariable(el, astName);
                this.println(this.labeledElementASTType + " " + astName + "_in = " + elementRef + ";");
            }
            return;
        }
        if (this.grammar.buildAST && this.syntacticPredLevel == 0) {
            String astNameBase;
            String elementRef;
            boolean doNoGuessTest;
            boolean needASTDecl;
            boolean bl = needASTDecl = this.genAST && (el.getLabel() != null || el.getAutoGenType() != 3);
            if (el.getAutoGenType() != 3 && el instanceof TokenRefElement) {
                needASTDecl = true;
            }
            boolean bl2 = doNoGuessTest = this.grammar.hasSyntacticPredicate && needASTDecl;
            if (el.getLabel() != null) {
                elementRef = el.getLabel();
                astNameBase = el.getLabel();
            } else {
                elementRef = this.lt1Value;
                astNameBase = "tmp" + this.astVarNumber;
                ++this.astVarNumber;
            }
            if (needASTDecl) {
                if (el instanceof GrammarAtom) {
                    GrammarAtom ga = (GrammarAtom)el;
                    if (ga.getASTNodeType() != null) {
                        this.genASTDeclaration(el, astNameBase, ga.getASTNodeType());
                    } else {
                        this.genASTDeclaration(el, astNameBase, this.labeledElementASTType);
                    }
                } else {
                    this.genASTDeclaration(el, astNameBase, this.labeledElementASTType);
                }
            }
            String astName = astNameBase + "_AST";
            this.mapTreeVariable(el, astName);
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println(this.labeledElementASTType + " " + astName + "_in = null;");
            }
            if (doNoGuessTest) {
                // empty if block
            }
            if (el.getLabel() != null) {
                if (el instanceof GrammarAtom) {
                    this.println(astName + " = " + this.getASTCreateString((GrammarAtom)el, elementRef) + ";");
                } else {
                    this.println(astName + " = " + this.getASTCreateString(elementRef) + ";");
                }
            }
            if (el.getLabel() == null && needASTDecl) {
                elementRef = this.lt1Value;
                if (el instanceof GrammarAtom) {
                    this.println(astName + " = " + this.getASTCreateString((GrammarAtom)el, elementRef) + ";");
                } else {
                    this.println(astName + " = " + this.getASTCreateString(elementRef) + ";");
                }
                if (this.grammar instanceof TreeWalkerGrammar) {
                    this.println(astName + "_in = " + elementRef + ";");
                }
            }
            if (this.genAST) {
                switch (el.getAutoGenType()) {
                    case 1: {
                        if (this.grammar.inlineASTFactory) {
                            this.generateAddASTChild(astName);
                            break;
                        }
                        this.println("astFactory.addASTChild(currentAST, " + astName + ");");
                        break;
                    }
                    case 2: {
                        if (this.grammar.inlineASTFactory) {
                            this.generateMakeASTRoot(astName);
                            break;
                        }
                        this.println("astFactory.makeASTRoot(currentAST, " + astName + ");");
                        break;
                    }
                }
            }
            if (doNoGuessTest) {
                // empty if block
            }
        }
    }

    private void genErrorCatchForElement(AlternativeElement el) {
        RuleSymbol rs;
        if (el.getLabel() == null) {
            return;
        }
        String r = el.enclosingRuleName;
        if (this.grammar instanceof LexerGrammar) {
            r = CodeGenerator.encodeLexerRuleName(el.enclosingRuleName);
        }
        if ((rs = (RuleSymbol)this.grammar.getSymbol(r)) == null) {
            this.antlrTool.fatalError("panic: Enclosing rule not found!");
            return;
        }
        ExceptionSpec ex = rs.block.findExceptionSpec(el.getLabel());
        if (ex != null) {
            --this.tabs;
            this.println("}");
            this.genErrorHandler(ex);
        }
    }

    private void generateMakeASTRoot(String root) {
        this.println(root + ".addChild(root);");
        this.println("lastChild = root != null ? (" + this.labeledElementASTType + ") root.getLastSibling() : root;");
        this.println("root = " + root + ";");
    }

    private String lookaheadString(int k) {
        if (this.grammar instanceof TreeWalkerGrammar) {
            return "_t.getType()";
        }
        return "LA(" + k + ")";
    }

    private String mangleLiteral(String s) {
        String mangled = Tool.literalsPrefix;
        for (int i = 1; i < s.length() - 1; ++i) {
            if (!Character.isLetter(s.charAt(i)) && s.charAt(i) != '_') {
                return null;
            }
            mangled = mangled + s.charAt(i);
        }
        if (Tool.upperCaseMangledLiterals) {
            mangled = mangled.toUpperCase();
        }
        return mangled;
    }

    private void mapTreeVariable(AlternativeElement e, String name) {
        if (e instanceof TreeElement) {
            this.mapTreeVariable(((TreeElement)e).root, name);
            return;
        }
        String elName = null;
        if (e.getLabel() == null) {
            if (e instanceof TokenRefElement) {
                elName = ((TokenRefElement)e).atomText;
            } else if (e instanceof RuleRefElement) {
                elName = ((RuleRefElement)e).targetRule;
            }
        }
        if (elName != null) {
            if (this.treeVariableMap.get(elName) != null) {
                this.treeVariableMap.remove(elName);
                this.treeVariableMap.put(elName, NONUNIQUE);
            } else {
                this.treeVariableMap.put(elName, name);
            }
        }
    }

    private void setupGrammarParameters(Grammar g) {
        if (g instanceof ParserGrammar) {
            String suffix;
            Token tsuffix;
            this.labeledElementASTType = "AST";
            if (g.hasOption("ASTLabelType") && (tsuffix = g.getOption("ASTLabelType")) != null && (suffix = Str.stripFrontBack(tsuffix.getText(), "\"", "\"")) != null) {
                this.labeledElementASTType = suffix;
            }
            this.labeledElementType = "Token ";
            this.labeledElementInit = "null";
            this.commonExtraArgs = "";
            this.commonExtraParams = "";
            this.commonLocalVars = "";
            this.lt1Value = "LT(1)";
            this.exceptionThrown = "RecognitionException";
            this.throwNoViable = "noViableAlt(LT(1), getFilename());";
        } else if (g instanceof LexerGrammar) {
            this.labeledElementType = "char ";
            this.labeledElementInit = "'\\0'";
            this.commonExtraArgs = "";
            this.commonExtraParams = "boolean _createToken";
            this.commonLocalVars = "int _ttype; Token _token=null; int _begin=text.length();";
            this.lt1Value = "LA(1)";
            this.exceptionThrown = "RecognitionException";
            this.throwNoViable = "throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());";
        } else if (g instanceof TreeWalkerGrammar) {
            String suffix;
            Token tsuffix;
            this.labeledElementASTType = "AST";
            this.labeledElementType = "AST";
            if (g.hasOption("ASTLabelType") && (tsuffix = g.getOption("ASTLabelType")) != null && (suffix = Str.stripFrontBack(tsuffix.getText(), "\"", "\"")) != null) {
                this.labeledElementASTType = suffix;
                this.labeledElementType = suffix;
            }
            if (!g.hasOption("ASTLabelType")) {
                g.setOption("ASTLabelType", new Token(6, "AST"));
            }
            this.labeledElementInit = "null";
            this.commonExtraArgs = "_t";
            this.commonExtraParams = "AST _t";
            this.commonLocalVars = "";
            this.lt1Value = "(" + this.labeledElementASTType + ")_t";
            this.exceptionThrown = "RecognitionException";
            this.throwNoViable = "throw new NoViableAltException(_t);";
        } else {
            this.antlrTool.fatalError("panic: Unknown grammar type");
        }
    }
}

