/*
 * Decompiled with CFR 0.152.
 */
package fuego.parser;

import fuego.parser.ANTLRHashString;
import fuego.parser.ANTLRStringBuffer;
import fuego.parser.CharStreamException;
import fuego.parser.InputBuffer;
import fuego.parser.LexerSharedInputState;
import fuego.parser.MismatchedCharException;
import fuego.parser.RecognitionException;
import fuego.parser.Token;
import fuego.parser.TokenStream;
import fuego.parser.TokenStreamException;
import fuego.parser.collections.impl.BitSet;
import java.util.Map;

public abstract class CharScanner
implements TokenStream {
    protected Token _returnToken = null;
    protected boolean caseSensitive = true;
    protected boolean caseSensitiveLiterals = true;
    protected boolean commitToPath = false;
    protected ANTLRHashString hashString;
    protected LexerSharedInputState inputState;
    protected Map<ANTLRHashString, Integer> literals;
    protected boolean saveConsumedInput = true;
    protected int tabsize = 8;
    protected ANTLRStringBuffer text = new ANTLRStringBuffer();
    protected Class tokenObjectClass;
    protected int traceDepth = 0;
    static final char NO_CHAR = '\u0000';
    public static final char EOF_CHAR = '\uffff';

    public CharScanner() {
        this.hashString = new ANTLRHashString(this);
        this.setTokenObjectClass("fuego.parser.CommonToken");
    }

    public CharScanner(InputBuffer cb) {
        this();
        this.inputState = new LexerSharedInputState(cb);
    }

    public CharScanner(LexerSharedInputState sharedState) {
        this();
        this.inputState = sharedState;
    }

    public void setCaseSensitive(boolean t) {
        this.caseSensitive = t;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public final boolean getCaseSensitiveLiterals() {
        return this.caseSensitiveLiterals;
    }

    public void setColumn(int c) {
        this.inputState.column = c;
    }

    public int getColumn() {
        return this.inputState.column;
    }

    public void setCommitToPath(boolean commit) {
        this.commitToPath = commit;
    }

    public boolean getCommitToPath() {
        return this.commitToPath;
    }

    public void setFilename(String f) {
        this.inputState.filename = f;
    }

    public String getFilename() {
        return this.inputState.filename;
    }

    public InputBuffer getInputBuffer() {
        return this.inputState.input;
    }

    public void setInputState(LexerSharedInputState state) {
        this.inputState = state;
    }

    public LexerSharedInputState getInputState() {
        return this.inputState;
    }

    public void setLine(int line) {
        this.inputState.line = line;
    }

    public int getLine() {
        return this.inputState.line;
    }

    public void setTabSize(int size) {
        this.tabsize = size;
    }

    public int getTabSize() {
        return this.tabsize;
    }

    public void setText(String s) {
        this.resetText();
        this.text.append(s);
    }

    public String getText() {
        return this.text.toString();
    }

    public Token getTokenObject() {
        return this._returnToken;
    }

    public void setTokenObjectClass(String cl) {
        try {
            this.tokenObjectClass = Class.forName(cl);
        }
        catch (ClassNotFoundException ce) {
            this.panic("ClassNotFoundException: " + cl);
        }
    }

    public char LA(int i) throws CharStreamException {
        if (this.caseSensitive) {
            return this.inputState.input.LA(i);
        }
        return this.toLower(this.inputState.input.LA(i));
    }

    public void append(char c) {
        if (this.saveConsumedInput) {
            this.text.append(c);
        }
    }

    public void append(String s) {
        if (this.saveConsumedInput) {
            this.text.append(s);
        }
    }

    public void commit() {
        this.inputState.input.commit();
    }

    public void consume() throws CharStreamException {
        if (this.inputState.guessing == 0) {
            char c = this.LA(1);
            if (this.caseSensitive) {
                this.append(c);
            } else {
                this.append(this.inputState.input.LA(1));
            }
            if (c == '\t') {
                this.tab();
            } else {
                ++this.inputState.column;
            }
        }
        this.inputState.input.consume();
    }

    public void consumeUntil(int c) throws CharStreamException {
        while (this.LA(1) != '\uffff' && this.LA(1) != c) {
            this.consume();
        }
    }

    public void consumeUntil(BitSet set) throws CharStreamException {
        while (this.LA(1) != '\uffff' && !set.member(this.LA(1))) {
            this.consume();
        }
    }

    public int mark() {
        return this.inputState.input.mark();
    }

    public void match(char c) throws MismatchedCharException, CharStreamException {
        if (this.LA(1) != c) {
            throw new MismatchedCharException(this.LA(1), c, false, this);
        }
        this.consume();
    }

    public void match(BitSet b) throws MismatchedCharException, CharStreamException {
        if (!b.member(this.LA(1))) {
            throw new MismatchedCharException(this.LA(1), b, false, this);
        }
        this.consume();
    }

    public void match(String s) throws MismatchedCharException, CharStreamException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (this.LA(1) != s.charAt(i)) {
                throw new MismatchedCharException(this.LA(1), s.charAt(i), false, this);
            }
            this.consume();
        }
    }

    public void matchNot(char c) throws MismatchedCharException, CharStreamException {
        if (this.LA(1) == c) {
            throw new MismatchedCharException(this.LA(1), c, true, this);
        }
        this.consume();
    }

    public void matchRange(char c1, char c2) throws MismatchedCharException, CharStreamException {
        if (this.LA(1) < c1 || this.LA(1) > c2) {
            throw new MismatchedCharException(this.LA(1), c1, c2, false, this);
        }
        this.consume();
    }

    public void newline() {
        ++this.inputState.line;
        this.inputState.column = 1;
    }

    public void panic() {
        System.err.println("CharScanner: panic");
        System.exit(1);
    }

    public void panic(String s) {
        System.err.println("CharScanner; panic: " + s);
        System.exit(1);
    }

    public void reportError(RecognitionException ex) {
        System.err.println(ex);
    }

    public void reportError(String s) {
        if (this.getFilename() == null) {
            System.err.println("error: " + s);
        } else {
            System.err.println(this.getFilename() + ": error: " + s);
        }
    }

    public void reportWarning(String s) {
        if (this.getFilename() == null) {
            System.err.println("warning: " + s);
        } else {
            System.err.println(this.getFilename() + ": warning: " + s);
        }
    }

    public void resetText() {
        this.text.setLength(0);
        this.inputState.tokenStartColumn = this.inputState.column;
        this.inputState.tokenStartLine = this.inputState.line;
    }

    public void rewind(int pos) {
        this.inputState.input.rewind(pos);
    }

    public void tab() {
        int c = this.getColumn();
        int nc = ((c - 1) / this.tabsize + 1) * this.tabsize + 1;
        this.setColumn(nc);
    }

    public int testLiteralsTable(int ttype) {
        this.hashString.setBuffer(this.text.getBuffer(), this.text.length());
        Integer literalsIndex = this.literals.get(this.hashString);
        if (literalsIndex != null) {
            ttype = literalsIndex;
        }
        return ttype;
    }

    public int testLiteralsTable(String txt, int ttype) {
        ANTLRHashString s = new ANTLRHashString(txt, this);
        Integer literalsIndex = this.literals.get(s);
        if (literalsIndex != null) {
            ttype = literalsIndex;
        }
        return ttype;
    }

    public char toLower(char c) {
        return Character.toLowerCase(c);
    }

    public void traceIn(String rname) throws CharStreamException {
        ++this.traceDepth;
        this.traceIndent();
        System.out.println("> lexer " + rname + "; c==" + this.LA(1));
    }

    public void traceIndent() {
        for (int i = 0; i < this.traceDepth; ++i) {
            System.out.print(" ");
        }
    }

    public void traceOut(String rname) throws CharStreamException {
        this.traceIndent();
        System.out.println("< lexer " + rname + "; c==" + this.LA(1));
        --this.traceDepth;
    }

    public void uponEOF() throws TokenStreamException, CharStreamException {
    }

    protected Token makeToken(int t) {
        try {
            Token tok = (Token)this.tokenObjectClass.newInstance();
            tok.setType(t);
            tok.setColumn(this.inputState.tokenStartColumn);
            tok.setLine(this.inputState.tokenStartLine);
            return tok;
        }
        catch (InstantiationException ie) {
            this.panic("can't instantiate token: " + this.tokenObjectClass);
        }
        catch (IllegalAccessException iae) {
            this.panic("Token class is not accessible" + this.tokenObjectClass);
        }
        return Token.badToken;
    }
}

