/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.formdesigner.protocol;

import java.io.Serializable;
import oracle.bpm.web.formdesigner.json.JSONException;
import oracle.bpm.web.formdesigner.json.JSONObject;
import oracle.bpm.web.formdesigner.json.JSONString;
import oracle.bpm.web.formdesigner.protocol.ApplicationMessage;

public class TransportMessage
implements JSONString,
Serializable {
    private final ApplicationMessage applicationMessage;
    private final String id;
    private static final String ID = "tmsgId";
    public static final String ASYNCHRONIC_ID = "0";
    private static final String TRANSPORT_MESSAGE = "tmessage";

    public TransportMessage(String id, ApplicationMessage applicationMessage) {
        assert (id != null) : "Transport ID must not be null";
        this.id = id;
        this.applicationMessage = applicationMessage;
    }

    public static TransportMessage valueOf(JSONObject jsonObject) throws JSONException {
        String id = jsonObject.getString(ID);
        ApplicationMessage message = ApplicationMessage.valueOf(jsonObject.getJSONObject(TRANSPORT_MESSAGE));
        return new TransportMessage(id, message);
    }

    public String getId() {
        return this.id;
    }

    public ApplicationMessage getApplicationMessage() {
        return this.applicationMessage;
    }

    @Override
    public String toJSONString() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(ID, this.getId());
        jsonObject.put(TRANSPORT_MESSAGE, this.getApplicationMessage().toJSONString());
        return jsonObject.toString();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(ID, this.getId());
        jsonObject.put(TRANSPORT_MESSAGE, this.getApplicationMessage().toJSONObject());
        return jsonObject;
    }

    public boolean isSynchronic() {
        return this.id != null && !this.id.equals(ASYNCHRONIC_ID);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransportMessage)) {
            return false;
        }
        TransportMessage that = (TransportMessage)o;
        if (this.applicationMessage != null ? !this.applicationMessage.equals(that.applicationMessage) : that.applicationMessage != null) {
            return false;
        }
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        int result = this.applicationMessage != null ? this.applicationMessage.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }
}

