/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.formdesigner.protocol;

import java.io.Serializable;
import oracle.bpm.web.formdesigner.json.JSONException;
import oracle.bpm.web.formdesigner.json.JSONObject;
import oracle.bpm.web.formdesigner.json.JSONString;
import oracle.bpm.web.formdesigner.protocol.JSONable;
import oracle.bpm.xobject.presentationmodel.XFormComponentType;

public class RegisterValue
implements Serializable,
JSONable,
JSONString {
    private boolean focusable = true;
    private boolean moveable = true;
    private boolean overlay;
    private XFormComponentType type;
    private static final String TYPE = "type";
    private static final String FOCUSABLE = "focusable";
    private static final String MOVEABLE = "moveable";
    private static final String OVERLAYED = "overlayed";
    private static final String PROPERTIES = "properties";

    public static RegisterValue valueOf(JSONObject jsonObject) throws JSONException {
        RegisterValue value = new RegisterValue();
        if (jsonObject.has(TYPE)) {
            value.setComponentType(XFormComponentType.valueOf(jsonObject.getString(TYPE)));
        }
        if (jsonObject.has(FOCUSABLE)) {
            value.setFocusable(Boolean.valueOf(jsonObject.getString(FOCUSABLE)));
        }
        if (jsonObject.has(MOVEABLE)) {
            value.setMoveable(Boolean.valueOf(jsonObject.getString(MOVEABLE)));
        }
        return value;
    }

    public void setComponentType(XFormComponentType type) {
        this.type = type;
    }

    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    public void setOverlayed(boolean overlay) {
        this.overlay = overlay;
    }

    public void setMoveable(boolean moveable) {
        this.moveable = moveable;
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        if (this.type != null) {
            jsonObject.put(TYPE, this.type.toString());
        }
        jsonObject.put(FOCUSABLE, Boolean.toString(this.focusable));
        jsonObject.put(MOVEABLE, Boolean.toString(this.moveable));
        jsonObject.put(OVERLAYED, Boolean.toString(this.overlay));
        return jsonObject;
    }

    @Override
    public String toJSONString() throws JSONException {
        return this.toJSONObject().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisterValue that = (RegisterValue)o;
        return this.focusable == that.focusable && this.overlay == that.overlay && this.moveable == that.moveable && this.type == that.type;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.focusable ? 1 : 0);
        result = 31 * result + (this.moveable ? 1 : 0);
        result = 31 * result + (this.overlay ? 1 : 0);
        return result;
    }
}

