/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.formdesigner.protocol;

import java.io.Serializable;
import oracle.bpm.web.formdesigner.json.JSONException;
import oracle.bpm.web.formdesigner.json.JSONObject;
import oracle.bpm.web.formdesigner.json.JSONString;
import oracle.bpm.web.formdesigner.protocol.JSONable;

public class PropertyValue
implements Serializable,
JSONable,
JSONString {
    private String name;
    private String value;
    private static final String NAME = "name";
    private static final String VALUE = "value";

    public PropertyValue(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static PropertyValue valueOf(JSONObject jsonObject) throws JSONException {
        return new PropertyValue(jsonObject.getString(NAME), jsonObject.getString(VALUE));
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NAME, this.name);
        jsonObject.put(VALUE, this.value);
        return jsonObject;
    }

    @Override
    public String toJSONString() throws JSONException {
        return this.toJSONObject().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyValue action = (PropertyValue)o;
        if (this.name != null ? !this.name.equals(action.name) : action.name != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(action.value) : action.value != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

