/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.formdesigner.protocol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.web.formdesigner.json.JSONArray;
import oracle.bpm.web.formdesigner.json.JSONException;
import oracle.bpm.web.formdesigner.json.JSONObject;
import oracle.bpm.web.formdesigner.json.JSONString;
import oracle.bpm.web.formdesigner.protocol.ComponentProperty;
import oracle.bpm.web.formdesigner.protocol.JSONable;
import oracle.bpm.web.formdesigner.protocol.PropertyValue;

public class PropertiesValue
implements Serializable,
JSONable,
JSONString {
    private List<PropertyValue> values = new ArrayList<PropertyValue>();
    private static final String VALUES = "values";

    public static PropertiesValue valueOf(JSONObject jsonObject) throws JSONException {
        PropertiesValue properties = new PropertiesValue();
        JSONArray valuesJsonArray = jsonObject.getJSONArray(VALUES);
        for (int i = 0; i < valuesJsonArray.length(); ++i) {
            JSONObject jsonArrayObject = valuesJsonArray.getJSONObject(i);
            properties.values.add(PropertyValue.valueOf(jsonArrayObject));
        }
        return properties;
    }

    public void addValue(String id, String label) {
        this.values.add(new PropertyValue(id, label));
    }

    public void addValue(ComponentProperty property, String value) {
        this.values.add(new PropertyValue(property.toString(), value));
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONArray contextActionArray = new JSONArray();
        for (PropertyValue contextAction : this.values) {
            contextActionArray.put(contextAction.toJSONObject());
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(VALUES, contextActionArray);
        return jsonObject;
    }

    @Override
    public String toJSONString() throws JSONException {
        return this.toJSONObject().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertiesValue that = (PropertiesValue)o;
        return !(this.values != null ? !((Object)this.values).equals(that.values) : that.values != null);
    }

    public int hashCode() {
        int result = this.values != null ? ((Object)this.values).hashCode() : 0;
        return result;
    }
}

