/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.formdesigner.protocol;

import java.io.Serializable;
import oracle.bpm.web.formdesigner.json.JSONException;
import oracle.bpm.web.formdesigner.json.JSONObject;
import oracle.bpm.web.formdesigner.json.JSONString;
import oracle.bpm.web.formdesigner.protocol.TransportMessage;

public class NetworkMessage
implements JSONString,
Serializable {
    private final String networkId;
    private final TransportMessage transportMessage;
    public static String NETWORK_ID_VALUE = "SWT";
    private static final String NETWORK_ID = "header";
    private static final String TRANSPORT_MESSAGE = "message";

    public NetworkMessage(TransportMessage message) {
        this(NETWORK_ID_VALUE, message);
    }

    public NetworkMessage(String networkId, TransportMessage message) {
        this.networkId = networkId;
        this.transportMessage = message;
    }

    public static NetworkMessage valueOf(String jsonString) throws JSONException {
        jsonString = jsonString.replace("\n", "\\n");
        JSONObject jsonObject = new JSONObject(jsonString);
        String id = jsonObject.getString(NETWORK_ID);
        TransportMessage message = TransportMessage.valueOf(jsonObject.getJSONObject(TRANSPORT_MESSAGE));
        return new NetworkMessage(id, message);
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public TransportMessage getTransportMessage() {
        return this.transportMessage;
    }

    @Override
    public String toJSONString() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NETWORK_ID, this.getNetworkId());
        jsonObject.put(TRANSPORT_MESSAGE, this.getTransportMessage().toJSONObject());
        return jsonObject.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetworkMessage)) {
            return false;
        }
        NetworkMessage that = (NetworkMessage)o;
        if (this.networkId != null ? !this.networkId.equals(that.networkId) : that.networkId != null) {
            return false;
        }
        return !(this.transportMessage != null ? !this.transportMessage.equals(that.transportMessage) : that.transportMessage != null);
    }

    public int hashCode() {
        int result = this.networkId != null ? this.networkId.hashCode() : 0;
        result = 31 * result + (this.transportMessage != null ? this.transportMessage.hashCode() : 0);
        return result;
    }
}

