/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.formdesigner.protocol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.web.formdesigner.json.JSONArray;
import oracle.bpm.web.formdesigner.json.JSONException;
import oracle.bpm.web.formdesigner.json.JSONObject;
import oracle.bpm.web.formdesigner.json.JSONString;
import oracle.bpm.web.formdesigner.protocol.ComponentContextAction;
import oracle.bpm.web.formdesigner.protocol.ComponentContextActionGroup;
import oracle.bpm.web.formdesigner.protocol.JSONable;

public class MenuValue
implements Serializable,
JSONable,
JSONString {
    private String action;
    private String name;
    private List<MenuValue> values = new ArrayList<MenuValue>();
    private static final String VALUES = "values";
    private static final String NAME = "name";
    private static final String ACTION = "action";

    public MenuValue() {
        this("TOP_LEVEL", null);
    }

    private MenuValue(String name, String action) {
        this.name = name;
        this.action = action;
        this.values = new ArrayList<MenuValue>();
    }

    public static MenuValue valueOf(JSONObject jsonObject) throws JSONException {
        String name = jsonObject.getString(NAME);
        String action = jsonObject.getString(ACTION);
        MenuValue menus = new MenuValue(name, action);
        JSONArray valuesJsonArray = jsonObject.getJSONArray(VALUES);
        for (int i = 0; i < valuesJsonArray.length(); ++i) {
            JSONObject jsonArrayObject = valuesJsonArray.getJSONObject(i);
            menus.values.add(MenuValue.valueOf(jsonArrayObject));
        }
        return menus;
    }

    public void addValue(ComponentContextActionGroup group) {
        MenuValue value = new MenuValue(group.getId(), group.getLabel());
        List<ComponentContextAction> enabledActions = group.getEnabledActions();
        for (ComponentContextAction action : enabledActions) {
            value.addValue(action);
        }
        this.values.add(value);
    }

    public void addValue(ComponentContextAction action) {
        if (action instanceof ComponentContextActionGroup) {
            this.addValue((ComponentContextActionGroup)action);
        } else {
            this.values.add(new MenuValue(action.getId(), action.getLabel()));
        }
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONArray contextActionArray = new JSONArray();
        for (MenuValue contextAction : this.values) {
            contextActionArray.put(contextAction.toJSONObject());
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NAME, this.name);
        jsonObject.put(ACTION, this.action);
        jsonObject.put(VALUES, contextActionArray);
        return jsonObject;
    }

    @Override
    public String toJSONString() throws JSONException {
        return this.toJSONObject().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenuValue that = (MenuValue)o;
        return !(this.values != null ? !((Object)this.values).equals(that.values) : that.values != null);
    }

    public int hashCode() {
        int result = this.values != null ? ((Object)this.values).hashCode() : 0;
        return result;
    }
}

