/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.formdesigner.protocol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.web.formdesigner.json.JSONArray;
import oracle.bpm.web.formdesigner.json.JSONException;
import oracle.bpm.web.formdesigner.json.JSONObject;
import oracle.bpm.web.formdesigner.json.JSONString;
import oracle.bpm.web.formdesigner.protocol.JSONable;
import oracle.bpm.web.formdesigner.protocol.PropertyValue;

public class InitializationValue
implements Serializable,
JSONable,
JSONString {
    private List<Object> values;
    private static final String INIT_VALUES = "initValues";

    public static InitializationValue valueOf(JSONObject jsonObject) throws JSONException {
        InitializationValue initializationValue = new InitializationValue();
        JSONArray jsonArray = jsonObject.getJSONArray(INIT_VALUES);
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                JSONObject object = jsonArray.getJSONObject(i);
                initializationValue.addPropertyValue(PropertyValue.valueOf(object));
                continue;
            }
            catch (JSONException e) {
                initializationValue.addStringValue(jsonArray.getString(i));
            }
        }
        return initializationValue;
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(INIT_VALUES, this.values);
        return jsonObject;
    }

    @Override
    public String toJSONString() throws JSONException {
        return this.toJSONObject().toString();
    }

    public void addPropertyValue(PropertyValue value) {
        this.addValue(value);
    }

    public void addStringValue(String value) {
        this.addValue(value);
    }

    public List getValues() {
        return this.values;
    }

    private void addValue(Object value) {
        if (this.values == null) {
            this.values = new ArrayList<Object>();
        }
        this.values.add(value);
    }
}

