/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.formdesigner.protocol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpm.web.formdesigner.json.JSONArray;
import oracle.bpm.web.formdesigner.json.JSONException;
import oracle.bpm.web.formdesigner.json.JSONObject;
import oracle.bpm.web.formdesigner.json.JSONString;
import oracle.bpm.web.formdesigner.protocol.ApplicationMessage;

public class GroupValue
implements JSONString {
    final Iterable<ApplicationMessage> values;

    public GroupValue(Iterable<ApplicationMessage> values) {
        this.values = values;
    }

    public static GroupValue valueOf(JSONArray jsonObject) throws JSONException {
        List<ApplicationMessage> values;
        if (jsonObject != null) {
            values = new ArrayList(jsonObject.length());
            for (int i = 0; i < jsonObject.length(); ++i) {
                JSONObject appJsonObject = jsonObject.getJSONObject(i);
                ApplicationMessage applicationMessage = ApplicationMessage.valueOf(appJsonObject);
                values.add(applicationMessage);
            }
        } else {
            values = Collections.emptyList();
        }
        return new GroupValue(values);
    }

    @Override
    public String toJSONString() throws JSONException {
        JSONArray array = new JSONArray();
        for (ApplicationMessage value : this.values) {
            array.put(value.toJSONObject());
        }
        return array.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroupValue)) {
            return false;
        }
        GroupValue that = (GroupValue)o;
        return !(this.values == null ? that.values != null : !this.values.equals(that.values));
    }

    public int hashCode() {
        return this.values != null ? this.values.hashCode() : 0;
    }
}

