/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.formdesigner.protocol;

import oracle.bpm.ui.FontStyle;
import oracle.bpm.xobject.presentationmodel.ColorProperties;
import oracle.bpm.xobject.presentationmodel.EasyFullBorderPropertiesSetter;
import oracle.bpm.xobject.presentationmodel.FontProperties;
import oracle.bpm.xobject.presentationmodel.FullBorderProperties;
import oracle.bpm.xobject.presentationmodel.HorizontalAlignmentProperties;
import oracle.bpm.xobject.presentationmodel.SimpleBorderProperties;
import oracle.bpm.xobject.presentationmodel.XFormLabel;
import oracle.bpm.xobject.presentationmodel.XFormLink;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

public enum ComponentProperty {
    TEXT{

        @Override
        public void setValue(XFormXMLObject object, String value) {
            if (object instanceof XFormLink) {
                XFormLink link = (XFormLink)object;
                link.setTextValue(value);
            } else {
                XFormLabel presentationObject = (XFormLabel)object;
                presentationObject.value.value_d = value;
            }
        }

        @Override
        public String getValue(XFormXMLObject object) {
            if (object instanceof XFormLink) {
                XFormLink link = (XFormLink)object;
                return link.getTextValue();
            }
            XFormLabel presentationObject = (XFormLabel)object;
            return presentationObject.value.value_d;
        }
    }
    ,
    FONT_BOLD{

        @Override
        public void setValue(XFormXMLObject object, String value) {
            boolean bold = Boolean.valueOf(value);
            FontProperties fontProperties = (FontProperties)((Object)object);
            FontStyle style = fontProperties.getFontStyle();
            boolean italic = style.isItalic();
            FontStyle newStyle = FontStyle.valueOf(bold, italic);
            fontProperties.setFontStyle(newStyle);
        }

        @Override
        public String getValue(XFormXMLObject fontProperties) {
            FontStyle fontStyle = ((FontProperties)((Object)fontProperties)).getFontStyle();
            return "" + fontStyle.isBold();
        }
    }
    ,
    FONT_ITALIC{

        @Override
        public void setValue(XFormXMLObject object, String value) {
            boolean italic = Boolean.valueOf(value);
            FontProperties fontProperties = (FontProperties)((Object)object);
            FontStyle style = fontProperties.getFontStyle();
            boolean bold = style.isBold();
            FontStyle newStyle = FontStyle.valueOf(bold, italic);
            fontProperties.setFontStyle(newStyle);
        }

        @Override
        public String getValue(XFormXMLObject fontProperties) {
            FontStyle fontStyle = ((FontProperties)((Object)fontProperties)).getFontStyle();
            return "" + fontStyle.isItalic();
        }
    }
    ,
    CSS_CLASS{

        @Override
        public void setValue(XFormXMLObject object, String value) {
            XFormPresentationXMLObject presentationObject = (XFormPresentationXMLObject)object;
            presentationObject.setCssClass(value);
        }

        @Override
        public String getValue(XFormXMLObject object) {
            XFormPresentationXMLObject presentationObject = (XFormPresentationXMLObject)object;
            return presentationObject.getCssClass();
        }
    }
    ,
    BGCOLOR{

        @Override
        public void setValue(XFormXMLObject object, String value) {
            ColorProperties presentationObject = (ColorProperties)((Object)object);
            presentationObject.setBgcolor(value);
        }

        @Override
        public String getValue(XFormXMLObject object) {
            ColorProperties presentationObject = (ColorProperties)((Object)object);
            return presentationObject.getBgcolor();
        }
    }
    ,
    FGCOLOR{

        @Override
        public void setValue(XFormXMLObject object, String value) {
            ColorProperties presentationObject = (ColorProperties)((Object)object);
            presentationObject.setFgcolor(value);
        }

        @Override
        public String getValue(XFormXMLObject object) {
            ColorProperties presentationObject = (ColorProperties)((Object)object);
            return presentationObject.getFgcolor();
        }
    }
    ,
    FONT_SIZE{

        @Override
        public void setValue(XFormXMLObject fontProperties, String value) {
            int fontSize = Integer.valueOf(value);
            ((FontProperties)((Object)fontProperties)).setFontsize(fontSize);
        }

        @Override
        public String getValue(XFormXMLObject fontProperties) {
            int fontSize = ((FontProperties)((Object)fontProperties)).getFontsize();
            return "" + fontSize;
        }
    }
    ,
    FONT_FACE{

        @Override
        public void setValue(XFormXMLObject fontProperties, String value) {
            ((FontProperties)((Object)fontProperties)).setFonttype(value);
        }

        @Override
        public String getValue(XFormXMLObject fontProperties) {
            return ((FontProperties)((Object)fontProperties)).getFonttype();
        }
    }
    ,
    HORIZONTAL_ALIGNMENT{

        @Override
        public void setValue(XFormXMLObject alignmentProperties, String value) {
            ((HorizontalAlignmentProperties)((Object)alignmentProperties)).setAlignment(value);
        }

        @Override
        public String getValue(XFormXMLObject alignmentProperties) {
            return ((HorizontalAlignmentProperties)((Object)alignmentProperties)).getAlignment();
        }
    }
    ,
    SIMPLE_BORDER{

        @Override
        public void setValue(XFormXMLObject borderProperties, String value) {
            SimpleBorderProperties simpleBorderProperties = (SimpleBorderProperties)((Object)borderProperties);
            EasyFullBorderPropertiesSetter.setPropertiesFromCSV(simpleBorderProperties, value);
        }

        @Override
        public String getValue(XFormXMLObject borderProperties) {
            SimpleBorderProperties simpleBorderProperties = (SimpleBorderProperties)((Object)borderProperties);
            return EasyFullBorderPropertiesSetter.getPropertiesAsCSV(simpleBorderProperties);
        }
    }
    ,
    TOP_BORDER{

        @Override
        public void setValue(XFormXMLObject borderProperties, String value) {
            FullBorderProperties fullBorderProperties = (FullBorderProperties)((Object)borderProperties);
            SimpleBorderProperties simpleBorderProperties = EasyFullBorderPropertiesSetter.getTopBorderAsSimple(fullBorderProperties);
            EasyFullBorderPropertiesSetter.setPropertiesFromCSV(simpleBorderProperties, value);
        }

        @Override
        public String getValue(XFormXMLObject borderProperties) {
            FullBorderProperties fullBorderProperties = (FullBorderProperties)((Object)borderProperties);
            SimpleBorderProperties simpleBorderProperties = EasyFullBorderPropertiesSetter.getTopBorderAsSimple(fullBorderProperties);
            return EasyFullBorderPropertiesSetter.getPropertiesAsCSV(simpleBorderProperties);
        }
    }
    ,
    BOTTOM_BORDER{

        @Override
        public void setValue(XFormXMLObject borderProperties, String value) {
            FullBorderProperties fullBorderProperties = (FullBorderProperties)((Object)borderProperties);
            SimpleBorderProperties simpleBorderProperties = EasyFullBorderPropertiesSetter.getBottomBorderAsSimple(fullBorderProperties);
            EasyFullBorderPropertiesSetter.setPropertiesFromCSV(simpleBorderProperties, value);
        }

        @Override
        public String getValue(XFormXMLObject borderProperties) {
            FullBorderProperties fullBorderProperties = (FullBorderProperties)((Object)borderProperties);
            SimpleBorderProperties simpleBorderProperties = EasyFullBorderPropertiesSetter.getBottomBorderAsSimple(fullBorderProperties);
            return EasyFullBorderPropertiesSetter.getPropertiesAsCSV(simpleBorderProperties);
        }
    }
    ,
    LEFT_BORDER{

        @Override
        public void setValue(XFormXMLObject borderProperties, String value) {
            FullBorderProperties fullBorderProperties = (FullBorderProperties)((Object)borderProperties);
            SimpleBorderProperties simpleBorderProperties = EasyFullBorderPropertiesSetter.getLeftBorderAsSimple(fullBorderProperties);
            EasyFullBorderPropertiesSetter.setPropertiesFromCSV(simpleBorderProperties, value);
        }

        @Override
        public String getValue(XFormXMLObject borderProperties) {
            FullBorderProperties fullBorderProperties = (FullBorderProperties)((Object)borderProperties);
            SimpleBorderProperties simpleBorderProperties = EasyFullBorderPropertiesSetter.getLeftBorderAsSimple(fullBorderProperties);
            return EasyFullBorderPropertiesSetter.getPropertiesAsCSV(simpleBorderProperties);
        }
    }
    ,
    RIGHT_BORDER{

        @Override
        public void setValue(XFormXMLObject borderProperties, String value) {
            FullBorderProperties fullBorderProperties = (FullBorderProperties)((Object)borderProperties);
            SimpleBorderProperties simpleBorderProperties = EasyFullBorderPropertiesSetter.getRightBorderAsSimple(fullBorderProperties);
            EasyFullBorderPropertiesSetter.setPropertiesFromCSV(simpleBorderProperties, value);
        }

        @Override
        public String getValue(XFormXMLObject borderProperties) {
            FullBorderProperties fullBorderProperties = (FullBorderProperties)((Object)borderProperties);
            SimpleBorderProperties simpleBorderProperties = EasyFullBorderPropertiesSetter.getRightBorderAsSimple(fullBorderProperties);
            return EasyFullBorderPropertiesSetter.getPropertiesAsCSV(simpleBorderProperties);
        }
    };


    public void setValue(XFormXMLObject object, String value) {
    }

    public String getValue(XFormXMLObject object) {
        return null;
    }
}

