/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.formdesigner.protocol;

import java.io.Serializable;
import oracle.bpm.web.formdesigner.json.JSONException;
import oracle.bpm.web.formdesigner.json.JSONObject;
import oracle.bpm.web.formdesigner.protocol.JSONable;

public class ComponentId
implements Serializable,
JSONable {
    private final String modelId;
    private final String presentationId;
    private static final String MODEL_ID = "modelId";
    private static final String PRESENTATION_ID = "presentationId";

    public ComponentId(String modelId) {
        this(modelId, null);
    }

    public ComponentId(String modelId, String presentationId) {
        this.modelId = modelId;
        this.presentationId = presentationId;
    }

    public static ComponentId valueOf(JSONObject jsonObject) throws JSONException {
        String presentationId;
        assert (jsonObject != null) : "jsonObject must not be null";
        String modelId = jsonObject.getString(MODEL_ID);
        assert (modelId != null) : "modelId must not be null";
        try {
            presentationId = jsonObject.getString(PRESENTATION_ID);
        }
        catch (JSONException e) {
            presentationId = null;
        }
        return new ComponentId(modelId, presentationId);
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getPresentationId() {
        return this.presentationId;
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(MODEL_ID, this.getModelId());
        jsonObject.put(PRESENTATION_ID, this.getPresentationId());
        return jsonObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentId that = (ComponentId)o;
        if (this.modelId != null ? !this.modelId.equals(that.modelId) : that.modelId != null) {
            return false;
        }
        return !(this.presentationId != null ? !this.presentationId.equals(that.presentationId) : that.presentationId != null);
    }

    public int hashCode() {
        int result = this.modelId != null ? this.modelId.hashCode() : 0;
        result = 31 * result + (this.presentationId != null ? this.presentationId.hashCode() : 0);
        return result;
    }
}

