/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.formdesigner.protocol;

import java.io.Serializable;
import oracle.bpm.log.Log;
import oracle.bpm.web.formdesigner.json.JSONArray;
import oracle.bpm.web.formdesigner.json.JSONException;
import oracle.bpm.web.formdesigner.json.JSONObject;
import oracle.bpm.web.formdesigner.json.JSONString;
import oracle.bpm.web.formdesigner.protocol.GroupValue;
import oracle.bpm.web.formdesigner.protocol.InitializationValue;
import oracle.bpm.web.formdesigner.protocol.JSONable;
import oracle.bpm.web.formdesigner.protocol.MenuValue;
import oracle.bpm.web.formdesigner.protocol.PropertiesValue;
import oracle.bpm.web.formdesigner.protocol.RegisterValue;

public class ApplicationMessageValue
implements Serializable,
JSONable {
    private final Object value;
    protected static final String VALUE = "value";

    protected ApplicationMessageValue(Object value) {
        this.value = value;
    }

    public static ApplicationMessageValue newBooleanValue(boolean value) {
        return new ApplicationMessageValue(value);
    }

    public static ApplicationMessageValue newStringValue(String value) {
        return new ApplicationMessageValue(value);
    }

    public static ApplicationMessageValue newRegisterValue(RegisterValue value) {
        return new ApplicationMessageValue(value);
    }

    public static ApplicationMessageValue newGroupValue(GroupValue value) {
        return new ApplicationMessageValue(value);
    }

    public static ApplicationMessageValue newInitializationValue(InitializationValue value) {
        return new ApplicationMessageValue(value);
    }

    public static ApplicationMessageValue newPropertiesItemsValue(PropertiesValue value) {
        return new ApplicationMessageValue(value);
    }

    public static ApplicationMessageValue newMenuItemsValue(MenuValue value) {
        return new ApplicationMessageValue(value);
    }

    public static ApplicationMessageValue valueOf(JSONObject jsonObject) throws JSONException {
        ApplicationMessageValue applicationMessageValue;
        try {
            applicationMessageValue = new ApplicationMessageValue(jsonObject.getJSONObject(VALUE));
        }
        catch (JSONException e) {
            applicationMessageValue = new ApplicationMessageValue(jsonObject.getString(VALUE));
        }
        return applicationMessageValue;
    }

    public String getStringValue() {
        String valueStr;
        if (this.value instanceof JSONString) {
            try {
                valueStr = ((JSONString)this.value).toJSONString();
            }
            catch (JSONException e) {
                if (Log.isDebugging()) {
                    Log.logDebug(e);
                }
                valueStr = this.value.toString();
            }
        } else if (this.value != null && this.value.getClass().isArray()) {
            try {
                JSONArray arrayValue = new JSONArray(this.value);
                valueStr = arrayValue.toString();
            }
            catch (JSONException e) {
                if (Log.isDebugging()) {
                    Log.logDebug(e);
                }
                valueStr = this.value.toString();
            }
        } else {
            valueStr = this.value != null ? this.value.toString() : "";
        }
        return valueStr;
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(VALUE, this.value);
        return jsonObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationMessageValue that = (ApplicationMessageValue)o;
        return this.getStringValue().equals(that.getStringValue());
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public class ValueException
    extends JSONException {
        public ValueException(String message) {
            super(message);
        }

        public ValueException(Throwable t) {
            super(t);
        }
    }
}

