/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.formdesigner.protocol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.bpm.web.formdesigner.json.JSONArray;
import oracle.bpm.web.formdesigner.json.JSONException;
import oracle.bpm.web.formdesigner.json.JSONObject;
import oracle.bpm.web.formdesigner.json.JSONString;
import oracle.bpm.web.formdesigner.protocol.ApplicationAddMessageValue;
import oracle.bpm.web.formdesigner.protocol.ApplicationCTODragMessageValue;
import oracle.bpm.web.formdesigner.protocol.ApplicationErrorMessageValue;
import oracle.bpm.web.formdesigner.protocol.ApplicationKeyMessageValue;
import oracle.bpm.web.formdesigner.protocol.ApplicationMessageAction;
import oracle.bpm.web.formdesigner.protocol.ApplicationMessageValue;
import oracle.bpm.web.formdesigner.protocol.ApplicationPropertyMessageValue;
import oracle.bpm.web.formdesigner.protocol.ComponentId;
import oracle.bpm.web.formdesigner.protocol.JSONable;

public class ApplicationMessage
implements JSONString,
JSONable,
Serializable {
    private final ApplicationMessageAction action;
    private final List<ComponentId> componentIds;
    private final ApplicationMessageValue value;
    private static final String ACTION = "action";
    private static final String COMPONENT_IDS = "componentIds";
    private static final String DATA = "data";

    private ApplicationMessage(ApplicationMessageAction action, List<ComponentId> componentIds, ApplicationMessageValue value) {
        this.action = action;
        this.value = value;
        this.componentIds = componentIds;
    }

    public static ApplicationMessage newApplicationMessage(ApplicationMessageAction action, ApplicationMessageValue value) {
        return new ApplicationMessage(action, null, value);
    }

    public static ApplicationMessage newApplicationMessage(ApplicationMessageAction action, ComponentId componentId, ApplicationMessageValue value) {
        return ApplicationMessage.newApplicationMessage(action, Arrays.asList(componentId), value);
    }

    public static ApplicationMessage newApplicationMessage(ApplicationMessageAction action, List<ComponentId> componentIds, ApplicationMessageValue value) {
        return new ApplicationMessage(action, componentIds, value);
    }

    public static ApplicationMessage newApplicationMessage(ApplicationMessageAction action, ComponentId componentId) {
        return ApplicationMessage.newApplicationMessage(action, Arrays.asList(componentId));
    }

    public static ApplicationMessage newApplicationMessage(ApplicationMessageAction action, List<ComponentId> componentIds) {
        return new ApplicationMessage(action, componentIds, null);
    }

    public static ApplicationMessage valueOf(JSONObject jsonObject) throws JSONException {
        ApplicationMessageAction type = ApplicationMessageAction.valueOf(jsonObject.getString(ACTION));
        ApplicationMessageValue value = null;
        if (jsonObject.has(DATA) && !jsonObject.isNull(DATA)) {
            JSONObject dataJSONObject = jsonObject.getJSONObject(DATA);
            switch (type) {
                case ADD: {
                    value = ApplicationAddMessageValue.valueOf(dataJSONObject);
                    break;
                }
                case KEY_EVENT: {
                    value = ApplicationKeyMessageValue.valueOf(dataJSONObject);
                    break;
                }
                case CHANGE: {
                    value = ApplicationPropertyMessageValue.valueOf(dataJSONObject);
                    break;
                }
                case CTOS_DRAG: {
                    value = ApplicationCTODragMessageValue.valueOf(dataJSONObject);
                    break;
                }
                case LOG: 
                case ERROR: 
                case WARNING: {
                    value = ApplicationErrorMessageValue.valueOf(dataJSONObject);
                    break;
                }
                default: {
                    value = ApplicationMessageValue.valueOf(dataJSONObject);
                }
            }
        }
        ArrayList<ComponentId> componentIds = null;
        if (jsonObject.has(COMPONENT_IDS)) {
            JSONArray jsonArray = jsonObject.getJSONArray(COMPONENT_IDS);
            componentIds = new ArrayList<ComponentId>(jsonArray.length());
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonComponentId = new JSONObject(jsonArray.getString(i));
                ComponentId componentId = ComponentId.valueOf(jsonComponentId);
                componentIds.add(componentId);
            }
        }
        return new ApplicationMessage(type, componentIds, value);
    }

    public List<ComponentId> getComponentIds() {
        return this.componentIds;
    }

    public ApplicationMessageValue getValue() {
        return this.value;
    }

    public ApplicationMessageAction getAction() {
        return this.action;
    }

    @Override
    public String toJSONString() throws JSONException {
        return this.toJSONObject().toString();
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(ACTION, this.getAction());
        if (this.getValue() != null) {
            jsonObject.put(DATA, this.getValue().toJSONObject());
        }
        if (this.componentIds != null) {
            JSONArray jsonComponentIds = new JSONArray();
            for (ComponentId componentId : this.componentIds) {
                jsonComponentIds.put(componentId.toJSONObject());
            }
            jsonObject.put(COMPONENT_IDS, jsonComponentIds);
        }
        return jsonObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationMessage that = (ApplicationMessage)o;
        if (this.action != that.action) {
            return false;
        }
        if (this.componentIds != null ? !((Object)this.componentIds).equals(that.componentIds) : that.componentIds != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.componentIds != null ? ((Object)this.componentIds).hashCode() : 0;
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

