/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.formdesigner.protocol;

import oracle.bpm.web.formdesigner.json.JSONException;
import oracle.bpm.web.formdesigner.json.JSONObject;
import oracle.bpm.web.formdesigner.protocol.ApplicationMessageValue;

public class ApplicationErrorMessageValue
extends ApplicationMessageValue {
    private String fileName;
    private String lineNumber;
    private String message;
    private String stack;
    private String stringVal;

    public ApplicationErrorMessageValue(String fileName, String lineNumber, String message, String stack, String stringVal) {
        super(message);
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.message = message;
        this.stack = stack;
        this.stringVal = stringVal;
    }

    public static ApplicationErrorMessageValue valueOf(JSONObject jsonObject) throws JSONException {
        JSONObject object = jsonObject.getJSONObject("value");
        String fileNameStr = object.isNull("fileName") ? null : object.getString("fileName");
        String lineNumberStr = object.isNull("lineNumber") ? null : object.getString("lineNumber");
        String messageStr = object.isNull("message") ? null : object.getString("message");
        String stackArr = object.isNull("stack") ? null : object.getString("stack");
        String stringValArr = object.isNull("stringVal") ? null : object.getString("stringVal");
        return new ApplicationErrorMessageValue(fileNameStr, lineNumberStr, messageStr, stackArr, stringValArr);
    }

    public boolean isReadyMessage() {
        return this.valueIsOfType(LogMessageValueType.READY);
    }

    public boolean isLoadingFinishedMessage() {
        return this.valueIsOfType(LogMessageValueType.LOADING_FINISHED);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getLineNumber() {
        return this.lineNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStack() {
        return this.stack;
    }

    public String getStringVal() {
        return this.stringVal;
    }

    public String toString() {
        if (this.stringVal != null) {
            return this.stringVal;
        }
        String result = this.message + ". At file: " + this.fileName + " at line " + this.lineNumber + "\nStack: " + this.stack;
        return result;
    }

    private boolean valueIsOfType(LogMessageValueType type) {
        return type == LogMessageValueType.valueOf(this.getStringVal());
    }

    private static enum LogMessageValueType {
        READY,
        LOADING_FINISHED;

    }
}

