/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.formdesigner.protocol;

import oracle.bpm.util.Properties;
import oracle.bpm.web.formdesigner.json.JSONArray;
import oracle.bpm.web.formdesigner.json.JSONException;
import oracle.bpm.web.formdesigner.json.JSONObject;
import oracle.bpm.web.formdesigner.protocol.ApplicationAddMessageValue;
import oracle.bpm.web.formdesigner.protocol.ApplicationMessageValue;

public class ApplicationCTODragMessageValue
extends ApplicationMessageValue {
    private ApplicationAddMessageValue addMessageValue;
    private String dest;
    private boolean isAdd;
    private String moveId;
    private CTOTableStructure structure;
    private static final String DESTINATION = "destination";
    private static final String TABLE_STRUCTURE = "tableStructure";
    private static final String ACTION = "action";
    private static final String MOVE_ACTION = "MOVE";
    private static final String ADD_ACTION = "ADD";

    public ApplicationCTODragMessageValue(CTOTableStructure structure, String dest, String value) {
        this(structure, dest);
        this.moveId = value;
        this.isAdd = false;
    }

    public ApplicationCTODragMessageValue(CTOTableStructure structure, String dest, ApplicationAddMessageValue addMessageValue) {
        this(structure, dest);
        this.addMessageValue = addMessageValue;
        this.isAdd = true;
    }

    protected ApplicationCTODragMessageValue(CTOTableStructure structure, String dest) {
        super(dest);
        this.structure = structure;
        this.dest = dest;
    }

    public static ApplicationCTODragMessageValue valueOf(JSONObject jsonObject) throws JSONException {
        try {
            String dest = jsonObject.getString(DESTINATION);
            JSONObject structure = jsonObject.getJSONObject(TABLE_STRUCTURE);
            CTOTableStructure table = CTOTableStructure.parse(structure);
            String action = jsonObject.getString(ACTION);
            if (MOVE_ACTION.equals(action)) {
                String value = jsonObject.getString("value");
                return new ApplicationCTODragMessageValue(table, dest, value);
            }
            if (ADD_ACTION.equals(action)) {
                ApplicationAddMessageValue addMessageValue = (ApplicationAddMessageValue)ApplicationAddMessageValue.valueOf(jsonObject);
                return new ApplicationCTODragMessageValue(table, dest, addMessageValue);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getMoveId() {
        return this.moveId;
    }

    public CTOTableStructure getStructure() {
        return this.structure;
    }

    public String getDest() {
        return this.dest;
    }

    public boolean isAdd() {
        return this.isAdd;
    }

    public Properties getAddProperties() {
        Properties properties = new Properties();
        if (this.addMessageValue != null) {
            String cols = this.addMessageValue.getColumns();
            String rows = this.addMessageValue.getRows();
            if (cols != null) {
                properties.put("columns", Integer.valueOf(cols));
            }
            if (rows != null) {
                properties.put("rows", Integer.valueOf(rows));
            }
        }
        return properties;
    }

    public String getAddComponentType() {
        String result = null;
        if (this.addMessageValue != null) {
            result = this.addMessageValue.getStringValue();
        }
        return result;
    }

    public static class CTOTableStructure {
        private String id;
        private CTOTableRow[] rows;

        public static CTOTableStructure parse(JSONObject object) throws JSONException {
            CTOTableStructure result = new CTOTableStructure();
            result.id = object.getString("id");
            JSONArray rows = object.getJSONArray("rows");
            int length = rows.length();
            result.rows = new CTOTableRow[length];
            for (int i = 0; i < length; ++i) {
                JSONObject eachRow = rows.getJSONObject(i);
                result.rows[i] = CTOTableRow.parse(eachRow);
            }
            return result;
        }

        public String getId() {
            return this.id;
        }

        public CTOTableRow[] getRows() {
            return this.rows;
        }
    }

    public static class CTOTableRow {
        private CTOTableCell[] cells;
        private String id;

        public static CTOTableRow parse(JSONObject object) throws JSONException {
            CTOTableRow result = new CTOTableRow();
            result.id = object.getString("id");
            JSONArray cells = object.getJSONArray("cells");
            int length = cells.length();
            result.cells = new CTOTableCell[length];
            for (int i = 0; i < length; ++i) {
                JSONObject eachRow = cells.getJSONObject(i);
                result.cells[i] = CTOTableCell.parse(eachRow);
            }
            return result;
        }

        public String getId() {
            return this.id;
        }

        public CTOTableCell[] getCells() {
            return this.cells;
        }
    }

    public static class CTOTableCell {
        private int colspan;
        private String id;
        private int rowspan;

        public static CTOTableCell parse(JSONObject object) throws JSONException {
            CTOTableCell result = new CTOTableCell();
            result.id = object.getString("id");
            result.rowspan = object.getInt("rowspan");
            result.colspan = object.getInt("colspan");
            return result;
        }

        public String getId() {
            return this.id;
        }

        public int getColspan() {
            return this.colspan;
        }

        public int getRowspan() {
            return this.rowspan;
        }
    }
}

