/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.tree;

import java.util.List;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.tree.ViewNode;
import oracle.bpm.designer.view.gui.tree.ViewTreeBuilder;
import oracle.bpm.designer.view.gui.tree.ViewTreeNode;
import oracle.bpm.extensionpoint.metadata.TreeNodeMetadata;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.project.model.presentation.views.ViewManager;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.tree.TreeNode;

@TreeNodeMetadata(objectType=ViewManager.class)
public class ViewsTreeNode
extends ViewNode {
    private List<ProjectDataObject> dataObjects;
    private boolean showAll;

    public ViewsTreeNode(ViewManager viewManager) {
        super((ProjectObject)viewManager);
        if (viewManager.getProject() == null) {
            throw new IllegalArgumentException();
        }
        this.setMsg(DesignerMsg.VIEWS);
        this.showAll = true;
        viewManager.getProject().addListener((ProjectListener)new ProjectListenerAdapter<View>(View.class){

            public void postObjectAdded(final View object, ProjectObject parent) {
                if (ViewsTreeNode.this.isLoaded()) {
                    UiUtilities.invokeAndWait((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ViewsTreeNode parentNode = ViewsTreeNode.this;
                            String parentId = null;
                            if (parentId != null) {
                                parentNode = ViewsTreeNode.this.findView(parentId);
                            }
                            if (parentNode == null) {
                                parentNode = ViewsTreeNode.this;
                            }
                            parentNode.add(new ViewTreeNode(object));
                            parentNode.reload();
                            parentNode.expand();
                        }
                    });
                }
            }

            public void postObjectRemoved(final View object, ProjectObject parent) {
                UiUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TreeNode child = ViewsTreeNode.this.findTreeNodeByUserObject(object);
                        if (child != null) {
                            child.removeFromParent();
                        }
                    }
                });
            }

            public void objectChanged(View projectObject, final ProjectEvent event) {
                UiUtilities.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TreeNode child = ViewsTreeNode.this.findTreeNodeByUserObject(event.getProjectObject());
                        if (child != null) {
                            child.nodeChanged();
                        }
                    }
                });
            }

            public void objectReplaced(View oldObject, View newObject) {
                if (ViewsTreeNode.this.isLoaded()) {
                    TreeNode child = ViewsTreeNode.this.findTreeNodeByUserObject(oldObject);
                    child.setUserObject((Object)newObject);
                }
            }
        });
    }

    public ViewsTreeNode(ViewManager viewManager, List<ProjectDataObject> dataObjects, boolean showAll) {
        this(viewManager);
        this.dataObjects = dataObjects;
        this.showAll = showAll;
    }

    public ViewManager getViewManager() {
        return (ViewManager)this.getUserObject();
    }

    @Override
    public ActionGroup createActions() {
        return new ActionGroup(LibMsg.VIEW);
    }

    public TreeNode findView(String id) {
        int lastIndex = 0;
        ViewNode node = this;
        do {
            String partialId = id;
            if ((lastIndex = id.indexOf(47, lastIndex + 1)) > 0) {
                partialId = id.substring(0, lastIndex);
            }
            node = (ViewNode)this.getChild(node, partialId);
        } while (lastIndex >= 0);
        return node;
    }

    @Override
    public Image resolveIcon() {
        return Image.create((Msg)DesignerMsg.VIEWS);
    }

    @Override
    public String getId() {
        return "";
    }

    @Override
    public ViewNode getParentViewNode() {
        return this;
    }

    @Override
    public View getView() {
        return null;
    }

    @Override
    public ViewsTreeNode getViewsTreeNode() {
        return this;
    }

    public void reload() {
        this.removeAllChildren();
        this.build();
        super.reload();
    }

    @Override
    public String toString() {
        return DesignerMsg.VIEWS.getString();
    }

    public Class<View> getSupportedTypes() {
        return View.class;
    }

    @Override
    protected void onLoading() {
        this.build();
    }

    private void build() {
        new ViewTreeBuilder(this.getProject()).build(this, this.dataObjects, this.showAll);
    }

    private TreeNode getChild(ViewNode node, String id) {
        ViewNode result = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            ViewNode viewNode = (ViewNode)node.getChildAt(i);
            View view = viewNode.getView();
            if (view == null || !id.equals(view.getId())) continue;
            result = viewNode;
            break;
        }
        return result;
    }
}

