/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.tree;

import oracle.bpm.designer.utils.IconFactory;
import oracle.bpm.designer.view.gui.ViewIconFactory;
import oracle.bpm.designer.view.gui.tree.ViewNode;
import oracle.bpm.designer.view.gui.tree.ViewsTreeNode;
import oracle.bpm.extensionpoint.metadata.TreeNodeMetadata;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.ui.Image;

@TreeNodeMetadata(objectType=View.class)
public class ViewTreeNode
extends ViewNode {
    public ViewTreeNode(View view) {
        super((ProjectObject)view.getProject());
        this.setUserObject(view);
    }

    public ViewTreeNode(Project project, View view) {
        super((ProjectObject)project);
        this.setUserObject(view);
    }

    @Override
    public Image resolveIcon() {
        Image result = ViewIconFactory.getIcon(this.getView().getType());
        if (this.isReadOnly()) {
            result = IconFactory.createReadOnly(result);
        }
        return result;
    }

    @Override
    public String getId() {
        return this.getView().getId();
    }

    @Override
    public ViewNode getParentViewNode() {
        return (ViewNode)this.getParent();
    }

    @Override
    public View getView() {
        return (View)this.getUserObject();
    }

    @Override
    public ViewsTreeNode getViewsTreeNode() {
        ViewNode parent;
        for (parent = (ViewNode)this.getParent(); parent != null && !(parent instanceof ViewsTreeNode); parent = (ViewNode)parent.getParent()) {
        }
        return (ViewsTreeNode)parent;
    }

    public boolean isReadOnly() {
        return this.getView().isReadOnly();
    }

    @Override
    public String toString() {
        return this.getId();
    }

    @Override
    protected int getMultipleActionsMask() {
        return 3;
    }
}

