/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.tree;

import java.util.Collection;
import java.util.List;
import oracle.bpm.designer.view.gui.tree.ViewNode;
import oracle.bpm.designer.view.gui.tree.ViewTreeNode;
import oracle.bpm.designer.view.gui.tree.ViewsTreeNode;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.presentation.FilterAttribute;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.tree.TreeNode;

public class ViewTreeBuilder {
    private Project project;

    public ViewTreeBuilder(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public ViewsTreeNode build(ViewsTreeNode viewsNode, List<ProjectDataObject> dataObjects, boolean showAll) {
        Collection views;
        FuegoWorker.Task task = new FuegoWorker.Task(){

            public Object run() {
                return ViewTreeBuilder.this.getProject().getViewManager().getViews();
            }
        };
        try {
            views = UiUtilities.isEventDispatchThread() ? (Collection)FuegoWorker.post((FuegoWorker.Task)task) : (Collection)task.run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ViewNode whereToAdd = viewsNode;
        for (View view : views) {
            ViewTreeNode actualView = new ViewTreeNode(this.getProject(), view);
            boolean doAdd = false;
            if (!showAll && dataObjects != null) {
                List list;
                if (view instanceof InstancesView && (list = ((InstancesView)view).getFilterAttributes()).size() == dataObjects.size()) {
                    for (int i = 0; i < list.size(); ++i) {
                        FilterAttribute filterAttribute = (FilterAttribute)list.get(i);
                        boolean bl = doAdd = filterAttribute.isParametric() && dataObjects.contains(filterAttribute.getVariable());
                        if (doAdd) {
                            continue;
                        }
                        break;
                    }
                }
            } else {
                doAdd = true;
            }
            this.findWhereToAddNode(whereToAdd, actualView).add((TreeNode)actualView);
            whereToAdd = actualView;
        }
        return viewsNode;
    }

    private TreeNode findWhereToAddNode(TreeNode possibleParent, ViewTreeNode viewToAdd) {
        String actualViewId = viewToAdd.getId();
        if (possibleParent instanceof ViewsTreeNode) {
            return possibleParent;
        }
        if (actualViewId.startsWith(((ViewTreeNode)possibleParent).getId() + '/') && Str.count(((ViewTreeNode)possibleParent).getId(), '/') == Str.count(actualViewId, '/') - 1) {
            return possibleParent;
        }
        return this.findWhereToAddNode(possibleParent.getParent(), viewToAdd);
    }
}

