/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.tree;

import java.util.List;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.action.NewViewPresentationAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.tree.PresentationTreeNode;
import oracle.bpm.extensionpoint.metadata.TreeNodeMetadata;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.project.model.presentation.presentations.PresentationManager;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiRunnableDecorator;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.view.PresentationType;

@TreeNodeMetadata(objectType=PresentationManager.class)
public class PresentationsTreeNode
extends ProjectObjectTreeNode<PresentationManager> {
    protected ProjectListenerAdapter<Presentation> listener;

    public PresentationsTreeNode(PresentationManager presentationManager) {
        super((ProjectObject)presentationManager);
        this.setMsg(DesignerMsg.PRESENTATIONS);
        this.listener = new ProjectListenerAdapter<Presentation>(Presentation.class){

            public void postObjectAdded(final Presentation presentation, ProjectObject parent) {
                new UiRunnableDecorator(0, new Runnable(){

                    @Override
                    public void run() {
                        if (presentation.getProject() == PresentationsTreeNode.this.getProject()) {
                            PresentationTreeNode treeNode = new PresentationTreeNode(presentation);
                            PresentationsTreeNode.this.add(treeNode);
                            PresentationsTreeNode.this.reload();
                        }
                    }
                }).run();
            }

            public void postObjectRemoved(final Presentation presentation, ProjectObject parent) {
                new UiRunnableDecorator(0, new Runnable(){

                    @Override
                    public void run() {
                        ProjectObjectTreeNode<Presentation> treeNode;
                        if (presentation.getProject() == PresentationsTreeNode.this.getProject() && (treeNode = PresentationsTreeNode.this.find(presentation)) != null) {
                            treeNode.removeFromParent();
                        }
                    }
                }).run();
            }
        };
        this.getProject().addListener(this.listener);
    }

    @Override
    public Image resolveIcon() {
        return Image.create((Msg)DesignerMsg.PRESENTATIONS);
    }

    @Override
    public ActionGroup createActions() {
        ActionGroup result = new ActionGroup(DesignerMsg.PRESENTATION);
        result.add((BaseAction)new NewViewPresentationAction(this.getProject(), true));
        return result;
    }

    public void removeNode(PresentationTreeNode node) {
        this.remove(node);
        this.reload();
    }

    @Override
    public String toString() {
        return DesignerMsg.VIEWS_PRESENTATION.getString();
    }

    protected void removeListeners() {
        this.getProject().removeListener(this.listener);
    }

    @Override
    protected void onLoading() {
        this.build();
    }

    private void build() {
        List presentations = this.getProject().getPresentationManager().getPresentations(PresentationType.INSTANCES);
        this.addDynamic(presentations);
    }
}

