/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.tree;

import java.util.Locale;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.action.CloseEditorAction;
import oracle.bpm.designer.action.DeleteViewPresentationAction;
import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.utils.IconFactory;
import oracle.bpm.designer.view.gui.tree.PresentationsTreeNode;
import oracle.bpm.extensionpoint.metadata.TreeNodeMetadata;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.project.model.presentation.presentations.PresentationManager;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.selection.DefaultSelection;

@TreeNodeMetadata(objectType=Presentation.class)
public class PresentationTreeNode
extends ProjectObjectTreeNode<Presentation> {
    private boolean isDefault;

    public PresentationTreeNode(Presentation presentation) {
        super((ProjectObject)presentation);
        PresentationManager presentationManager = this.getProject().getPresentationManager();
        this.isDefault = presentationManager.isDefaultPresentation((Presentation)this.getProjectObject());
    }

    @Override
    public Image resolveIcon() {
        if (this.isReadOnly()) {
            return IconFactory.createReadOnly(Image.create((Msg)DesignerMsg.VIEWS_PRESENTATION));
        }
        return Image.create((Msg)DesignerMsg.VIEWS_PRESENTATION);
    }

    public PresentationsTreeNode getParentNode() {
        return (PresentationsTreeNode)this.getParent();
    }

    public Presentation getPresentation() {
        return (Presentation)this.getUserObject();
    }

    public boolean isReadOnly() {
        return ((Presentation)this.getUserObject()).isReadOnly();
    }

    @Override
    public ActionGroup createActions() {
        ActionGroup result = new ActionGroup(this.getMsg());
        StudioEditor studioEditor = AbstractStudioWorkbench.getInstance().findEditorByObject(this.getUserObject());
        if (studioEditor == null) {
            result.add((BaseAction)new OpenObjectAction(this.getUserObject()));
        } else {
            result.add((BaseAction)new CloseEditorAction(this.getUserObject()));
        }
        if (!this.isDefault) {
            result.add((BaseAction)DeleteViewPresentationAction.getInstance());
        }
        return result;
    }

    public boolean delete() {
        if (this.isDefault) {
            return false;
        }
        DeleteViewPresentationAction action = DeleteViewPresentationAction.getInstance();
        action.setSelection(DefaultSelection.createSingle(this.getUserObject()));
        action.run();
        return true;
    }

    @Override
    public String toString() {
        return this.getPresentation().getLabel(Locale.getDefault());
    }
}

