/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.panels.newviewpanels.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.deployment.ProcessDeploymentUtils;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.deployment.ProcessDeployment;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.event.TableModelListener;
import oracle.bpm.ui.table.TableModel;

public class ProcessesTableModel
implements TableModel {
    private List<Process> processes = new ArrayList<Process>();
    private final Project project;
    private List<Integer> selectedProcesses = new ArrayList<Integer>();
    private final View view;

    public ProcessesTableModel(View view) {
        this.view = view;
        this.project = view.getProject();
        this.update();
    }

    public void addTableModelListener(TableModelListener l) {
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int columnIndex) {
        return DesignerMsg.PROCESSES.getString();
    }

    public int getRowCount() {
        return this.processes.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.processes.get(rowIndex).getDefaultLabel();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void removeTableModelListener(TableModelListener l) {
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }

    public int[] getSelection() {
        int[] selection = new int[this.selectedProcesses.size()];
        for (int i = 0; i < this.selectedProcesses.size(); ++i) {
            selection[i] = this.selectedProcesses.get(i);
        }
        return selection;
    }

    public void update() {
        this.processes.clear();
        Collection deployments = this.project.getDeployment().getTopology().getDeployments();
        List assignedProcesses = this.view.getAssignedProcessesList();
        for (ProcessDeployment deployment : deployments) {
            String processId = ProcessDeploymentUtils.getDeployedProcessId((ProcessDeployment)deployment);
            Process process = this.project.findProcess(ProcessDeploymentUtils.getProcessNameFromDeploymentId((String)processId));
            if (assignedProcesses.indexOf(processId) != -1) {
                this.selectedProcesses.add(assignedProcesses.indexOf(processId));
            }
            this.processes.add(process);
        }
    }
}

