/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.panels.newviewpanels.models;

import java.util.Locale;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.panels.newviewpanels.models.LabelModel;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.ui.LanguageChooser;
import oracle.bpm.ui.table.ProviderTableModel;

public class LabelsTableModel
extends ProviderTableModel<LabelModel> {
    private View view;

    public LabelsTableModel(View view) {
        this.view = view;
        this.setLabels(view.getLabels());
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    public Class getColumnClass(int columnIndex) {
        return columnIndex == 0 ? Locale.class : String.class;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        LabelModel model = (LabelModel)this.getRow(rowIndex);
        return columnIndex == 0 ? LanguageChooser.LanguageLabelProvider.INSTANCE.getText(model.getLocale()) : model.getValue();
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int columnIndex) {
        return columnIndex == 0 ? DesignerMsg.LANGUAGE.getString() : DesignerMsg.VALUE.getString();
    }

    public void setLabels(LocaleStringMap labels) {
        for (Locale locale : labels.keySet()) {
            if (locale == null) continue;
            this.addRow(new LabelModel(locale, (String)labels.get((Object)locale)));
        }
    }
}

