/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.panels.newviewpanels;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.ViewPanel;
import oracle.bpm.designer.view.gui.panels.ViewContainerPanel;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.GridLayout;
import oracle.bpm.ui.layout.Layout;

public class ViewPropertiesPanel
extends ViewContainerPanel {
    private CheckBox hiddenCheck;
    private CheckBox readOnlyCheck;

    public ViewPropertiesPanel(UiContainer parent, ViewPanel viewPanel, final View view) {
        super(parent, viewPanel, LibMsg.VIEW_PROPERTIES);
        this.setLayout((Layout)new GridLayout(1, 1, 5, 5));
        this.hiddenCheck = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.IS_HIDDEN);
        this.hiddenCheck.setSelected(view.isHidden());
        this.hiddenCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                view.setHidden(e.isStateSelected());
                ViewPropertiesPanel.this.setDirty(true);
            }
        });
        this.readOnlyCheck = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.IS_READONLY);
        this.readOnlyCheck.setSelected(view.isViewReadOnly());
        this.readOnlyCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                view.setViewReadOnly(e.isStateSelected());
                ViewPropertiesPanel.this.setDirty(true);
            }
        });
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, (UiComponent)this.hiddenCheck);
        this.setEnabled(enabled, (UiComponent)this.readOnlyCheck);
    }
}

