/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.panels.newviewpanels;

import java.util.List;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.ViewPanel;
import oracle.bpm.designer.view.gui.components.ActivitiesCombo;
import oracle.bpm.designer.view.gui.components.ConditionsComboBox;
import oracle.bpm.designer.view.gui.components.ProcessComboBox;
import oracle.bpm.designer.view.gui.panels.ViewContainerPanel;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.presentation.views.ActivityView;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;

public class ViewProcessesAndActivitiesPanel
extends ViewContainerPanel {
    private ActivitiesCombo activitiesComboBox;
    private ConditionsComboBox conditionsCombo;
    private ProcessComboBox processesComboBox;
    private ProjectListener<Process> processesListener;
    private Project project;
    private Panel rolesPanel;

    public ViewProcessesAndActivitiesPanel(UiContainer parent, ViewPanel viewPanel, ActivityView view, Panel rolesPanel, ConditionsComboBox relatedConditionsCombo) {
        super(parent, viewPanel);
        this.project = view.getProject();
        this.rolesPanel = rolesPanel;
        this.conditionsCombo = relatedConditionsCombo;
        this.setLayout((Layout)new BorderLayout());
        this.createPanel(view, this);
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, (UiComponent)this.activitiesComboBox);
        this.setEnabled(enabled, (UiComponent)this.rolesPanel);
        this.setEnabled(enabled, (UiComponent)this.conditionsCombo);
    }

    protected void onDispose() {
        this.project.removeListener(this.processesListener);
    }

    private void createPanel(ActivityView view, Panel processPanel) {
        String cols = "5dlu, fill:min(pref;200dlu):grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 20dlu, pref, 5dlu, pref, 15dlu";
        FormLayout layout = new FormLayout("5dlu, fill:min(pref;200dlu):grow, 5dlu", "5dlu, pref, 5dlu, pref, 20dlu, pref, 5dlu, pref, 15dlu");
        processPanel.setLayout((Layout)layout);
        CellConstraints cc = layout.createCellConstraints();
        this.processesComboBox = new ProcessComboBox(view.getProject(), (UiContainer)processPanel);
        this.processesComboBox.setToolTipMsg(DesignerMsg.PROCESSES_TOOLTIP);
        this.activitiesComboBox = new ActivitiesCombo((UiContainer)processPanel, (InstancesView)view, false);
        this.activitiesComboBox.setToolTipMsg(DesignerMsg.ACTIVITIES_TOOLTIP);
        processPanel.add((UiComponent)Label.create((UiContainer)processPanel, (Msg)DesignerMsg.PROCESSES), (Object)cc.xy(2, 2));
        processPanel.add((UiComponent)this.processesComboBox, (Object)cc.xy(2, 4));
        processPanel.add((UiComponent)Label.create((UiContainer)processPanel, (Msg)DesignerMsg.VIEWS_ACTIVITIES), (Object)cc.xy(2, 6));
        processPanel.add((UiComponent)this.activitiesComboBox, (Object)cc.xy(2, 8));
        this.loadProcessesCombo(view);
        this.loadActivitiesCombo(view);
        this.addListeners(view, this.processesComboBox);
        this.setDirty(false);
    }

    private void loadProcessesCombo(ActivityView view) {
        List assignedProcesses = view.getAssignedProcessesList();
        this.processesComboBox.setEnabled(true);
        if (!assignedProcesses.isEmpty()) {
            this.processesComboBox.setSelectedProcess((String)assignedProcesses.get(0));
            this.reloadActivitiesCombo(view);
            this.processesComboBox.getParent().revalidate();
        } else if (!this.processesComboBox.isEmpty()) {
            this.processesComboBox.setSelectedIndex(0);
            this.reloadActivitiesCombo(view);
            this.processesComboBox.getParent().revalidate();
        } else {
            this.processesComboBox.setEnabled(false);
            this.processesComboBox.setToolTipMsg(DesignerMsg.NO_PROCESSES_TO_SELECT);
            this.disableActivitiesCombo();
        }
    }

    private void reloadActivitiesCombo(ActivityView view) {
        this.loadActivitiesCombo(view);
        this.setDirty(true);
    }

    private void loadActivitiesCombo(ActivityView view) {
        this.activitiesComboBox.setEnabled(true);
        this.activitiesComboBox.setToolTipMsg(DesignerMsg.ACTIVITIES_TOOLTIP);
        this.activitiesComboBox.reload((InstancesView)view);
        FlowNode assignedNode = view.getAssignedActivity();
        if (assignedNode != null) {
            this.activitiesComboBox.setSelectedItem(assignedNode);
        } else if (!this.activitiesComboBox.isEmpty()) {
            this.activitiesComboBox.setSelectedIndex(0);
            this.activitiesComboBox.getParent().revalidate();
        } else {
            this.disableActivitiesCombo();
        }
        this.activitiesComboBox.repaint();
    }

    private void disableActivitiesCombo() {
        this.activitiesComboBox.setEnabled(false);
        this.activitiesComboBox.setToolTipMsg(DesignerMsg.NO_INTERACTIVE_ACTIVITIES_TO_SELECT);
    }

    private void addListeners(final ActivityView view, final ProcessComboBox processComboBox) {
        this.processesComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String process = (String)e.getItem();
                if (process != null) {
                    view.assignProcess(process);
                }
                ViewProcessesAndActivitiesPanel.this.reloadActivitiesCombo(view);
            }
        });
        this.processesListener = new ProjectListenerAdapter<Process>(Process.class){

            public Class<Process> getSupportedTypes() {
                return Process.class;
            }

            public void objectChanged(Process projectObject, ProjectEvent event) {
                processComboBox.reload();
                ViewProcessesAndActivitiesPanel.this.loadProcessesCombo(view);
            }

            public void objectReplaced(Process oldObject, Process newObject) {
            }

            public void postObjectAdded(Process object, ProjectObject parent) {
                processComboBox.reload();
                ViewProcessesAndActivitiesPanel.this.loadProcessesCombo(view);
            }

            public void postObjectRemoved(Process object, ProjectObject parent) {
                processComboBox.reload();
                ViewProcessesAndActivitiesPanel.this.loadProcessesCombo(view);
            }

            public void preObjectAdded(Process object, ProjectObject parent) throws ProjectException {
            }

            public void preObjectRemoved(Process object, ProjectObject parent) throws ProjectException {
            }
        };
        this.project.addListener(this.processesListener);
        this.activitiesComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FlowNode selectedNode = ViewProcessesAndActivitiesPanel.this.activitiesComboBox.getSelectedActivity();
                if (selectedNode != null) {
                    view.setActivity(selectedNode);
                }
                if (ViewProcessesAndActivitiesPanel.this.conditionsCombo != null) {
                    ViewProcessesAndActivitiesPanel.this.conditionsCombo.reload((InstancesView)view);
                }
                ViewProcessesAndActivitiesPanel.this.setDirty(true);
            }
        });
    }
}

