/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.panels.newviewpanels;

import oracle.bpm.designer.view.gui.panels.ViewFilterAttributesPanel;
import oracle.bpm.designer.view.gui.panels.ViewPanelComponentFactory;
import oracle.bpm.designer.view.gui.panels.ViewPanelDelegator;
import oracle.bpm.project.model.presentation.views.ActivityView;
import oracle.bpm.project.model.presentation.views.ApplicationsView;
import oracle.bpm.project.model.presentation.views.AttachmentsView;
import oracle.bpm.project.model.presentation.views.FolderView;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.view.ViewType;

public class ViewPanelBuilderNew {
    public static ViewPanelDelegator buildViewPanel(UiContainer viewPanel, View view, ViewPanelComponentFactory componentFactory) {
        ViewType viewType = view.getType();
        Panel panel = null;
        switch (viewType) {
            case ACTIVITY_INSTANCES: {
                panel = ViewPanelBuilderNew.buildActivityInstancesViewPanel(viewPanel, (ActivityView)view, componentFactory);
                break;
            }
            case INSTANCES: {
                panel = ViewPanelBuilderNew.buildInstancesViewPanel(viewPanel, (InstancesView)view, componentFactory);
                break;
            }
            case FOLDER: {
                panel = ViewPanelBuilderNew.buildFolderViewPanel(viewPanel, (FolderView)view, componentFactory);
                break;
            }
            case ATTACHMENTS: {
                panel = ViewPanelBuilderNew.buildAttachmentsViewPanel(viewPanel, (AttachmentsView)view, componentFactory);
                break;
            }
            case APPLICATIONS: {
                panel = ViewPanelBuilderNew.buildApplicationsViewPanel(viewPanel, (ApplicationsView)view, componentFactory);
                break;
            }
            default: {
                throw new IllegalArgumentException("ViewType " + viewType + " from view " + view + " does not have an associated view panel.");
            }
        }
        viewPanel.add((UiComponent)panel, (Object)"Center");
        return (ViewPanelDelegator)panel;
    }

    private static Panel buildActivityInstancesViewPanel(UiContainer viewPanel, ActivityView view, ViewPanelComponentFactory componentFactory) {
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        ViewPanelDelegator panel = new ViewPanelDelegator(viewPanel);
        FormLayout layout = new FormLayout("5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu", "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu");
        PanelBuilder builder = layout.createBuilder((Panel)panel);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)componentFactory.createHeaderPanel((UiContainer)panel), cc.xy(2, 2));
        Panel rolesPanel = componentFactory.createRolesPanel((UiContainer)panel);
        builder.add((UiComponent)rolesPanel, cc.xy(4, 4));
        ViewFilterAttributesPanel filterAttributesPanel = (ViewFilterAttributesPanel)componentFactory.createFilterAttributesPanel((UiContainer)panel, (InstancesView)view);
        builder.add((UiComponent)filterAttributesPanel, cc.xywh(2, 12, 3, 1));
        panel.add((UiComponent)componentFactory.createProcessesAndActivitiesPanel((UiContainer)panel, view, rolesPanel, filterAttributesPanel.getConditionsCombo()), cc.xy(2, 4));
        builder.add((UiComponent)componentFactory.createLabelsPanel((UiContainer)panel, (View)view), cc.xy(2, 6));
        builder.add((UiComponent)componentFactory.createFilterOptionsPanel((UiContainer)panel, (InstancesView)view), cc.xy(4, 6));
        builder.add((UiComponent)componentFactory.createViewPropertiesPanel((UiContainer)panel), cc.xy(2, 8));
        builder.add(componentFactory.createIncludeInstancesPanel(panel, (InstancesView)view), cc.xy(4, 8));
        builder.add((UiComponent)componentFactory.createPresentationPanel((UiContainer)panel), cc.xywh(2, 10, 3, 1));
        return panel;
    }

    private static Panel buildApplicationsViewPanel(UiContainer viewPanel, ApplicationsView viewModel, ViewPanelComponentFactory componentFactory) {
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        ViewPanelDelegator panel = new ViewPanelDelegator(viewPanel);
        FormLayout layout = new FormLayout("5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu", "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu");
        PanelBuilder builder = layout.createBuilder((Panel)panel);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)componentFactory.createHeaderPanel((UiContainer)panel), cc.xy(2, 2));
        builder.add((UiComponent)componentFactory.createProcessesPanel((UiContainer)panel, null), cc.xy(2, 4));
        builder.add((UiComponent)componentFactory.createRolesPanel((UiContainer)panel), cc.xy(4, 4));
        builder.add((UiComponent)componentFactory.createViewPropertiesPanel((UiContainer)panel), cc.xywh(2, 6, 3, 1));
        builder.add((UiComponent)componentFactory.createLabelsPanel((UiContainer)panel, (View)viewModel), cc.xywh(2, 8, 3, 1));
        return panel;
    }

    private static Panel buildAttachmentsViewPanel(UiContainer viewPanel, AttachmentsView viewModel, ViewPanelComponentFactory componentFactory) {
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        ViewPanelDelegator panel = new ViewPanelDelegator(viewPanel);
        FormLayout layout = new FormLayout("5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu", "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu");
        PanelBuilder builder = layout.createBuilder((Panel)panel);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)componentFactory.createHeaderPanel((UiContainer)panel), cc.xy(2, 2));
        builder.add((UiComponent)componentFactory.createProcessesPanel((UiContainer)panel, null), cc.xy(2, 4));
        builder.add((UiComponent)componentFactory.createRolesPanel((UiContainer)panel), cc.xy(4, 4));
        builder.add((UiComponent)componentFactory.createViewPropertiesPanel((UiContainer)panel), cc.xywh(2, 6, 3, 1));
        builder.add((UiComponent)componentFactory.createLabelsPanel((UiContainer)panel, (View)viewModel), cc.xywh(2, 8, 3, 1));
        return panel;
    }

    private static Panel buildFolderViewPanel(UiContainer viewPanel, FolderView viewModel, ViewPanelComponentFactory componentFactory) {
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:pref, 5dlu, pref, 5dlu, pref";
        ViewPanelDelegator panel = new ViewPanelDelegator(viewPanel);
        FormLayout layout = new FormLayout("5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu", "5dlu, pref, 5dlu, fill:pref, 5dlu, pref, 5dlu, pref");
        PanelBuilder builder = layout.createBuilder((Panel)panel);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)componentFactory.createHeaderPanel((UiContainer)panel), cc.xy(2, 2));
        builder.add((UiComponent)componentFactory.createRolesPanel((UiContainer)panel), cc.xy(2, 4));
        builder.add((UiComponent)componentFactory.createLabelsPanel((UiContainer)panel, (View)viewModel), cc.xy(4, 4));
        builder.add((UiComponent)componentFactory.createViewPropertiesPanel((UiContainer)panel), cc.xywh(2, 6, 3, 1));
        return panel;
    }

    private static Panel buildInstancesViewPanel(UiContainer viewPanel, InstancesView viewModel, ViewPanelComponentFactory componentFactory) {
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        ViewPanelDelegator panel = new ViewPanelDelegator(viewPanel);
        FormLayout layout = new FormLayout("5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu", "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu");
        panel.setLayout((Layout)layout);
        CellConstraints cc = layout.createCellConstraints();
        panel.add((UiComponent)componentFactory.createHeaderPanel((UiContainer)panel), cc.xy(2, 2));
        panel.add((UiComponent)componentFactory.createProcessesPanel((UiContainer)panel, null), cc.xy(2, 4));
        panel.add((UiComponent)componentFactory.createRolesPanel((UiContainer)panel), cc.xy(4, 4));
        panel.add((UiComponent)componentFactory.createLabelsPanel((UiContainer)panel, (View)viewModel), cc.xy(2, 8));
        panel.add((UiComponent)componentFactory.createFilterOptionsPanel((UiContainer)panel, viewModel), cc.xy(4, 8));
        panel.add((UiComponent)componentFactory.createViewPropertiesPanel((UiContainer)panel), cc.xy(2, 10));
        panel.add(componentFactory.createIncludeInstancesPanel(panel, viewModel), cc.xy(4, 10));
        panel.add((UiComponent)componentFactory.createPresentationPanel((UiContainer)panel), cc.xywh(2, 14, 3, 1));
        panel.add((UiComponent)componentFactory.createFilterAttributesPanel((UiContainer)panel, viewModel), cc.xywh(2, 18, 3, 1));
        return panel;
    }
}

