/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.panels.newviewpanels;

import fuego.papi.msg.PapiMsg;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.ViewPanel;
import oracle.bpm.designer.view.gui.panels.ViewContainerPanel;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.GridLayout;
import oracle.bpm.ui.layout.Layout;

public class ViewIncludeInstancesPanel
extends ViewContainerPanel {
    private CheckBox abortedCheck;
    private CheckBox completeCheck;
    private CheckBox inProcessCheck;

    public ViewIncludeInstancesPanel(Panel parent, ViewPanel viewPanel, InstancesView instancesView) {
        super((UiContainer)parent, viewPanel, DesignerMsg.INCLUDE_INSTANCES);
        this.setLayout((Layout)new GridLayout(1, 1, 5, 5));
        this.inProcessCheck = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.IN_PROCESS);
        this.inProcessCheck.setSelected(instancesView.isInProcess());
        this.completeCheck = CheckBox.create((UiContainer)this, (Msg)PapiMsg.COMPLETED);
        this.completeCheck.setSelected(instancesView.isComplete());
        this.abortedCheck = CheckBox.create((UiContainer)this, (Msg)PapiMsg.ABORTED);
        this.abortedCheck.setSelected(instancesView.isAborted());
        this.addChangeListeners();
        this.addDirtyListener(this.inProcessCheck, instancesView);
        this.addDirtyListener(this.abortedCheck, instancesView);
        this.addDirtyListener(this.completeCheck, instancesView);
    }

    private void addChangeListeners() {
        this.inProcessCheck.addItemListener(new ItemListener(){
            boolean fire = true;

            public void itemStateChanged(ItemEvent e) {
                if (this.fire && e.isStateDeselected()) {
                    boolean othersSelected;
                    boolean bl = othersSelected = ViewIncludeInstancesPanel.this.completeCheck.isSelected() || ViewIncludeInstancesPanel.this.abortedCheck.isSelected();
                    if (!othersSelected) {
                        this.fire = false;
                        ViewIncludeInstancesPanel.this.inProcessCheck.setSelected(true);
                        this.fire = true;
                    }
                }
            }
        });
        this.completeCheck.addItemListener((ItemListener)new InProcessCheckListener(this.inProcessCheck, this.abortedCheck));
        this.abortedCheck.addItemListener((ItemListener)new InProcessCheckListener(this.inProcessCheck, this.completeCheck));
    }

    private void addDirtyListener(CheckBox check, final InstancesView view) {
        check.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean isInProcess = ViewIncludeInstancesPanel.this.inProcessCheck.isSelected();
                boolean isComplete = ViewIncludeInstancesPanel.this.completeCheck.isSelected();
                boolean isAborted = ViewIncludeInstancesPanel.this.abortedCheck.isSelected();
                view.setStatusScope(isInProcess, isComplete, isAborted);
                ViewIncludeInstancesPanel.this.setDirty(true);
            }
        });
    }

    private class InProcessCheckListener
    implements ItemListener {
        private final CheckBox inProcessCheck;
        private final CheckBox otherCheck;

        public InProcessCheckListener(CheckBox inProcessCheck, CheckBox otherCheck) {
            this.otherCheck = otherCheck;
            this.inProcessCheck = inProcessCheck;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.isStateDeselected()) {
                boolean othersSelected;
                boolean bl = othersSelected = this.inProcessCheck.isSelected() || this.otherCheck.isSelected();
                if (!othersSelected) {
                    this.inProcessCheck.setSelected(true);
                }
            }
        }
    }
}

