/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.panels.newviewpanels;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.ViewPanel;
import oracle.bpm.designer.view.gui.components.ConditionsComboBox;
import oracle.bpm.designer.view.gui.components.conditions.ConditionRowEditorFactory;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanel;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanelBuilder;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanelEvent;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanelListener;
import oracle.bpm.designer.view.gui.models.FilterAttributeRowPanelModel;
import oracle.bpm.designer.view.gui.panels.ViewContainerPanel;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.presentation.FilterAttribute;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.project.presentation.FilterAttributeAdapter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.text.TextArea;

public class ViewFilterAttributesPanel
extends ViewContainerPanel {
    private UiComponent addFilterAttButton;
    private ConditionsComboBox conditionsCombo;
    private TextArea filterDescriptionLabel;
    private RowPanel filterTable;
    private CheckBox matchAllCheckBox;

    public ViewFilterAttributesPanel(UiContainer parent, ViewPanel viewPanel, InstancesView view) {
        super(parent, viewPanel, DesignerMsg.CONDITIONS);
        String columns = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, max(15dlu;pref)";
        FormLayout layout = new FormLayout("5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu:grow, 5dlu", "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, max(15dlu;pref)");
        PanelBuilder builder = layout.createBuilder((Panel)this);
        CellConstraints cc = layout.createCellConstraints();
        FilterAttributeRowPanelModel model = new FilterAttributeRowPanelModel(view);
        AddAction addAction = new AddAction(model);
        this.addFilterAttButton = this.createButton(addAction);
        Label conditionLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.ADD_CONDITION);
        this.conditionsCombo = new ConditionsComboBox((UiContainer)this, view);
        this.conditionsCombo.setSelectedIndex(0);
        ConditionRowEditorFactory editorFactory = new ConditionRowEditorFactory(view);
        this.filterTable = new RowPanelBuilder(model, editorFactory).createRemovableRowsPanel((UiContainer)this);
        this.matchAllCheckBox = this.createMatchAllFilterAttributesCheckBox((UiContainer)this, view);
        builder.add((UiComponent)this.matchAllCheckBox, cc.xywh(2, 4, 3, 1));
        builder.add((UiComponent)conditionLabel, cc.xy(2, 6));
        builder.add((UiComponent)this.conditionsCombo, cc.xy(4, 6));
        builder.add(this.addFilterAttButton, cc.xy(6, 6));
        builder.add((UiComponent)this.filterTable, cc.xywh(2, 8, 10, 1));
        this.addFiltersTableListener(view, this.filterTable);
        this.filterDescriptionLabel = new TextArea((UiContainer)this, ScrollPolicy.NEVER, ScrollPolicy.NEVER, false);
        this.filterDescriptionLabel.setRows(5);
        this.filterDescriptionLabel.setEditable(false);
        builder.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.FILTER_DESCRIPTION), cc.xyw(2, 12, 10));
        builder.add((UiComponent)this.filterDescriptionLabel, cc.xyw(2, 14, 10));
        this.updateFilterDescription((View)view);
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, this.addFilterAttButton);
        this.setEnabled(enabled, (UiComponent)this.conditionsCombo);
        this.setEnabled(enabled, (UiComponent)this.filterTable);
        this.setEnabled(enabled, (UiComponent)this.matchAllCheckBox);
    }

    public ConditionsComboBox getConditionsCombo() {
        return this.conditionsCombo;
    }

    private UiComponent createButton(BaseAction action) {
        ToolBar toolBar = new ToolBar((UiContainer)this);
        toolBar.add(action);
        return toolBar;
    }

    private CheckBox createMatchAllFilterAttributesCheckBox(UiContainer parent, final InstancesView view) {
        CheckBox box = CheckBox.create((UiContainer)parent, (Msg)DesignerMsg.MATCH_ALL);
        box.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                view.setMatchAll(e.isStateSelected());
                ViewFilterAttributesPanel.this.updateFilterDescription((View)view);
                ViewFilterAttributesPanel.this.setDirty(true);
            }
        });
        box.setSelected(view.isMatchAllSelected());
        return box;
    }

    private void addFiltersTableListener(final InstancesView view, final RowPanel filtersTable) {
        filtersTable.addListener(new RowPanelListener(){

            @Override
            public void rowAdded(RowPanelEvent event) {
                FilterAttribute attribute = ((FilterAttributeRowPanelModel.FilterAttributeModel)event.getRow()).getValue();
                view.addFilterAttribute(attribute);
                ViewFilterAttributesPanel.this.updateFilterDescription((View)view);
                ViewFilterAttributesPanel.this.setDirty(true);
            }

            @Override
            public void rowRemoved(RowPanelEvent event) {
                FilterAttribute attribute = ((FilterAttributeRowPanelModel.FilterAttributeModel)event.getRow()).getValue();
                view.removeFilterAttribute(attribute);
                ViewFilterAttributesPanel.this.updateFilterDescription((View)view);
                ViewFilterAttributesPanel.this.setDirty(true);
            }

            @Override
            public void rowUpdated(RowPanelEvent event) {
                view.updateFilterAttributes(((FilterAttributeRowPanelModel)filtersTable.getModel()).getFilterAttributes());
                ViewFilterAttributesPanel.this.updateFilterDescription((View)view);
                ViewFilterAttributesPanel.this.setDirty(true);
            }
        });
    }

    private void updateFilterDescription(View view) {
        String text = view.getProject().getViewManager().getFilterDescription(view);
        this.filterDescriptionLabel.setText(text);
        this.filterDescriptionLabel.setToolTipText(text);
    }

    private class AddAction
    extends BaseAction {
        private final FilterAttributeRowPanelModel model;

        public AddAction(FilterAttributeRowPanelModel model) {
            super(DesignerMsg.ADD);
            this.model = model;
        }

        public void run() {
            ProjectDataObject dataObject = (ProjectDataObject)ViewFilterAttributesPanel.this.conditionsCombo.getSelectedItem();
            FilterAttributeAdapter filterAttribute = new FilterAttributeAdapter(dataObject);
            filterAttribute.setVariable(dataObject);
            this.model.addFilterAttribute((FilterAttribute)filterAttribute);
            ViewFilterAttributesPanel.this.setDirty(true);
            ViewFilterAttributesPanel.this.revalidate();
            ViewFilterAttributesPanel.this.getParent().revalidate();
            ViewFilterAttributesPanel.this.revalidateScrollPane((UiContainer)ViewFilterAttributesPanel.this.filterTable);
            ViewFilterAttributesPanel.this.filterTable.repaint();
        }
    }
}

