/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.panels.newviewpanels;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.project.model.presentation.views.ViewManager;
import oracle.bpm.ui.event.TableModelListener;
import oracle.bpm.ui.table.TableModel;

public class RolesTableModel
implements TableModel {
    private List<String> roles = new ArrayList<String>();
    private List<Integer> selectedRoles = new ArrayList<Integer>();
    private View view;
    public static final String AUTOMATIC_HANDLER_ROLE = "AutomaticHandler";

    public RolesTableModel(View view) {
        this.view = view;
        this.update();
    }

    public void addTableModelListener(TableModelListener l) {
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int columnIndex) {
        return DesignerMsg.ROLES.getString();
    }

    public int getRowCount() {
        return this.roles.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.roles.get(rowIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void removeTableModelListener(TableModelListener l) {
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }

    public int[] getSelection() {
        int[] selection = new int[this.selectedRoles.size()];
        for (int i = 0; i < this.selectedRoles.size(); ++i) {
            selection[i] = this.selectedRoles.get(i);
        }
        return selection;
    }

    public void update() {
        this.roles.clear();
        List viewRoles = this.view.getRoles();
        List assignedRoles = this.view.getAssignedRolesList();
        for (Role role : viewRoles) {
            if (role.getId().equals(AUTOMATIC_HANDLER_ROLE)) continue;
            this.roles.add(role.getId());
            if (assignedRoles.indexOf(role.getId()) == -1) continue;
            this.selectedRoles.add(assignedRoles.indexOf(role.getId()));
        }
        ViewManager viewManager = this.view.getProject().getViewManager();
        Collection unexistentRoles = viewManager.getNonexistentRolesIds(this.view.getId());
        for (String nonExistentRole : unexistentRoles) {
            if (nonExistentRole.equals(AUTOMATIC_HANDLER_ROLE)) continue;
            this.roles.add(nonExistentRole);
            if (assignedRoles.indexOf(nonExistentRole) == -1) continue;
            this.selectedRoles.add(assignedRoles.indexOf(nonExistentRole));
        }
    }
}

