/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.panels.newviewpanels;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.panels.newviewpanels.models.LabelModel;
import oracle.bpm.designer.view.gui.panels.newviewpanels.models.LabelsTableModel;
import oracle.bpm.lang.Platform;
import oracle.bpm.locale.LocaleSupport;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.DialogFactory;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.LanguageChooser;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.BaseTablePanel;

public class LabelsPanel
extends BaseTablePanel {
    public LabelsPanel(UiContainer parent, View view) {
        super(parent, DesignerMsg.LABELS);
        this.setModel(new LabelsTableModel(view));
    }

    protected void addAction() {
        Object[] objects;
        Object[] availableLocales = this.getAvailableLocales();
        if (availableLocales.length == 0) {
            MessageDialog.showNotice((Msg)UIMsg.NO_MORE_LANGUAGES_AVAILABLE);
            return;
        }
        Locale defaultSelection = availableLocales.length == 1 ? availableLocales[0] : null;
        for (Object locale : objects = DialogFactory.showInputDialog((UiWindow)this.getParentWindow(), (Msg)UIMsg.ADD_LANGUAGE, (Msg)UIMsg.ADD_LANGUAGE, (Object[])availableLocales, (Object)defaultSelection, (boolean)true, (LabelProvider)LanguageChooser.LanguageLabelProvider.INSTANCE)) {
            this.getModel().addRow((Object)new LabelModel((Locale)locale, ""));
        }
    }

    private Locale[] getAvailableLocales() {
        ArrayList<Locale> availableLocales = new ArrayList<Locale>();
        List<LocaleSupport> list = Platform.getLocaleService().getSupportedLocales();
        LabelModel labelModel = new LabelModel(null, "");
        for (LocaleSupport ls : list) {
            Locale locale = ls.asJavaLocale();
            labelModel.setLocale(locale);
            if (this.getModel().getRowIndex((Object)labelModel) != -1) continue;
            availableLocales.add(locale);
        }
        return availableLocales.toArray(new Locale[availableLocales.size()]);
    }
}

