/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.panels.newviewpanels;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.view.ParticipantScope;

public class FilterOptionsPanel
extends Panel {
    private CheckBox caseSensitiveCheck;
    private ComboBox participantScopeCombo;

    public FilterOptionsPanel(UiContainer container, InstancesView view) {
        super(container, DesignerMsg.FILTER_OPTIONS);
        String cols = "5dlu, pref, 5dlu, pref, 5dlu";
        String rows = "5dlu, pref, 20dlu, pref, 35dlu";
        FormLayout layout = new FormLayout("5dlu, pref, 5dlu, pref, 5dlu", "5dlu, pref, 20dlu, pref, 35dlu");
        PanelBuilder builder = layout.createBuilder((Panel)this);
        CellConstraints cc = layout.createCellConstraints();
        this.participantScopeCombo = this.createParticipantScopeCombo((UiContainer)this, view);
        this.caseSensitiveCheck = this.createCaseSensitiveCheck((UiContainer)this, view);
        builder.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.GET_INSTANCES_ASSIGNED_TO), cc.xy(2, 2));
        builder.add((UiComponent)this.participantScopeCombo, cc.xy(4, 2));
        builder.add((UiComponent)this.caseSensitiveCheck, cc.xy(2, 4));
    }

    public void setEnabled(boolean enabled) {
    }

    private ComboBox<ParticipantScope> createParticipantScopeCombo(UiContainer parent, final InstancesView view) {
        ComboBox participantScopeCombo = UiFactory.createComboBox((UiContainer)parent, (Object[])ParticipantScope.values());
        participantScopeCombo.setLabelProvider((LabelProvider)new LabelProvider.Default<ParticipantScope>(){

            public String getText(ParticipantScope element) {
                return element.getMsg().getString();
            }
        });
        ParticipantScope participantScope = view.getParticipantScope();
        if (participantScope != null) {
            participantScopeCombo.setSelectedItem((Object)participantScope);
        } else {
            participantScopeCombo.setSelectedIndex(0);
        }
        participantScopeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    view.setParticipantScope((ParticipantScope)e.getItem());
                }
            }
        });
        return participantScopeCombo;
    }

    private CheckBox createCaseSensitiveCheck(UiContainer parent, final InstancesView view) {
        CheckBox caseSensitiveCombo = CheckBox.create((UiContainer)parent, (Msg)DesignerMsg.CASE_SENSITIVE_MATCHING);
        caseSensitiveCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                view.setCaseSensitive(e.isStateSelected());
            }
        });
        caseSensitiveCombo.setSelected(view.isCaseSensitiveFilterSelected());
        return caseSensitiveCombo;
    }
}

