/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.panels;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.ViewPanel;
import oracle.bpm.designer.view.gui.components.multiplecheckboxpanel.MultipleCheckBoxPanel;
import oracle.bpm.designer.view.gui.models.RolesPanelModel;
import oracle.bpm.designer.view.gui.panels.ViewContainerPanel;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SeparatorPanel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;

public class ViewRolesPanel
extends ViewContainerPanel {
    private PanelBuilder builder;
    private FormLayout layout;
    private RolesPanelModel model;
    private Project project;
    private MultipleCheckBoxPanel roleChecksPanel;

    public ViewRolesPanel(UiContainer parent, ViewPanel viewPanel, View view) {
        super(parent, viewPanel);
        this.project = view.getProject();
        this.model = new RolesPanelModel(view);
        this.initGui(view);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.roleChecksPanel.setEnabled(enabled);
    }

    public Project getProject() {
        return this.project;
    }

    public void addChangeListener(MultipleCheckBoxPanel.CheckChangedListener listener) {
        this.roleChecksPanel.addListener(listener);
    }

    public void load(View view) {
        this.roleChecksPanel.reload();
        this.roleChecksPanel.getParent().revalidate();
        this.revalidate();
        this.getParent().revalidate();
    }

    private void addApplyToChildrenButtonIfNeeded(Panel panel) {
        if (this.getProject().getViewManager().hasChildrenViews(this.model.getView())) {
            Button applyToChildrenButton = new Button((UiContainer)panel, DesignerMsg.APPLY_TO_CHILDREN);
            applyToChildrenButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                }
            });
            this.layout.appendRow("pref");
            CellConstraints cc = this.layout.createCellConstraints();
            this.builder.add((UiComponent)applyToChildrenButton, cc.xy(1, this.layout.getRowCount(), "right, bottom"));
            this.layout.appendRow("5dlu");
        }
    }

    private void initGui(final View view) {
        this.setLayout((Layout)new BorderLayout());
        Panel panel = new Panel((UiContainer)this);
        String cols = "fill:pref:grow";
        String rows = "5dlu, pref, 5dlu, pref";
        this.layout = new FormLayout(cols, rows);
        this.builder = this.layout.createBuilder(panel);
        CellConstraints cc = this.layout.createCellConstraints();
        SeparatorPanel rolesSeparator = new SeparatorPanel((UiContainer)panel, DesignerMsg.VIEWS_ROLES);
        this.builder.add((UiComponent)rolesSeparator, cc.xy(1, 2));
        this.roleChecksPanel = new MultipleCheckBoxPanel((UiContainer)panel, 2, this.model);
        this.roleChecksPanel.setToolTipText(DesignerMsg.VIEWS_ROLES.getDetail());
        this.builder.add((UiComponent)this.roleChecksPanel, cc.xy(1, 4));
        this.add((UiComponent)panel, "Center");
        this.addApplyToChildrenButtonIfNeeded(panel);
        this.addChangeListener(new MultipleCheckBoxPanel.CheckChangedListener(){

            @Override
            public void checkChanged(MultipleCheckBoxPanel.CheckChangedEvent event) {
                if (event.isSelected()) {
                    view.addRole((String)event.getItem());
                } else {
                    view.removeRole((String)event.getItem());
                }
                ViewRolesPanel.this.setDirty(true);
            }
        });
    }
}

