/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.panels;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.ViewPanel;
import oracle.bpm.designer.view.gui.panels.ViewContainerPanel;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SeparatorPanel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;

public class ViewPropertiesPanel
extends ViewContainerPanel {
    private CheckBox hiddenCheck;
    private CheckBox readOnlyCheck;

    public ViewPropertiesPanel(UiContainer parent, ViewPanel viewPanel, final View view) {
        super(parent, viewPanel);
        String cols = "5dlu, pref, fill:25dlu:grow, pref, fill:25dlu:grow";
        String rows = "5dlu, pref, 5dlu, pref";
        FormLayout layout = new FormLayout("5dlu, pref, fill:25dlu:grow, pref, fill:25dlu:grow", "5dlu, pref, 5dlu, pref");
        PanelBuilder builder = layout.createBuilder((Panel)this);
        CellConstraints cc = layout.createCellConstraints();
        SeparatorPanel viewSeparator = new SeparatorPanel((UiContainer)this, LibMsg.VIEW_PROPERTIES);
        this.hiddenCheck = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.IS_HIDDEN);
        this.hiddenCheck.setSelected(view.isHidden());
        this.hiddenCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                view.setHidden(e.isStateSelected());
                ViewPropertiesPanel.this.setDirty(true);
            }
        });
        this.readOnlyCheck = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.IS_READONLY);
        this.readOnlyCheck.setSelected(view.isViewReadOnly());
        this.readOnlyCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                view.setViewReadOnly(e.isStateSelected());
                ViewPropertiesPanel.this.setDirty(true);
            }
        });
        builder.add((UiComponent)viewSeparator, cc.xywh(1, 2, 5, 1));
        builder.add((UiComponent)this.hiddenCheck, cc.xy(2, 4));
        builder.add((UiComponent)this.readOnlyCheck, cc.xy(4, 4));
        layout.setColumnGroups((int[][])new int[][]{{2, 4}});
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, (UiComponent)this.hiddenCheck);
        this.setEnabled(enabled, (UiComponent)this.readOnlyCheck);
    }
}

