/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.panels;

import java.util.List;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.ViewPanel;
import oracle.bpm.designer.view.gui.ViewsListenerProvider;
import oracle.bpm.designer.view.gui.components.ConditionsComboBox;
import oracle.bpm.designer.view.gui.components.multiplecheckboxpanel.MultipleCheckBoxPanel;
import oracle.bpm.designer.view.gui.models.ProcessesPanelModel;
import oracle.bpm.designer.view.gui.panels.ViewContainerPanel;
import oracle.bpm.designer.view.gui.panels.ViewRolesPanel;
import oracle.bpm.project.deployment.ProcessDeploymentUtils;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.ui.events.UiProjectAdapter;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SeparatorPanel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;

public class ViewProcessesPanel
extends ViewContainerPanel {
    private ConditionsComboBox conditionsCombo;
    private MultipleCheckBoxPanel processChecksPanel;
    private Project project;
    private ProjectListener<Process> projectListener;

    public ViewProcessesPanel(UiContainer parent, ViewPanel viewPanel, View view, ViewRolesPanel rolesPanel, ConditionsComboBox relatedConditionsCombo) {
        super(parent, viewPanel);
        this.conditionsCombo = relatedConditionsCombo;
        this.project = view.getProject();
        String cols = "fill:pref:grow";
        String rows = "5dlu, pref, 5dlu, pref";
        FormLayout layout = new FormLayout("fill:pref:grow", "5dlu, pref, 5dlu, pref");
        PanelBuilder builder = layout.createBuilder((Panel)this);
        CellConstraints cc = layout.createCellConstraints();
        SeparatorPanel processesSeparator = new SeparatorPanel((UiContainer)this, DesignerMsg.PROCESSES);
        CheckChangedListenerImpl checkChangedListener = new CheckChangedListenerImpl(view, rolesPanel, relatedConditionsCombo);
        this.processChecksPanel = new MultipleCheckBoxPanel((UiContainer)this, 2, new ProcessesPanelModel(this.project, view), checkChangedListener);
        this.processChecksPanel.setToolTipText(DesignerMsg.PROCESSES_TOOLTIP.getString());
        builder.add((UiComponent)processesSeparator, cc.xy(1, 2));
        builder.add((UiComponent)this.processChecksPanel, cc.xy(1, 4));
        this.addProjectListener(view);
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, (UiComponent)this.conditionsCombo);
    }

    protected void onDispose() {
        this.project.removeListener(this.projectListener);
    }

    private void addProcessComponentListener(Process fuegoProcess) {
        fuegoProcess.getProject().addListener(ViewsListenerProvider.getInstance().getProcessListener());
    }

    private void addProjectListener(View view) {
        this.projectListener = new UiProjectAdapter(this.createModelListener(this));
        view.getProject().addListener(this.projectListener);
    }

    private ProjectListenerAdapter<Process> createModelListener(final Panel processesPanel) {
        return new ProjectListenerAdapter<Process>(Process.class){

            public void postObjectAdded(Process object, ProjectObject parent) {
                this.update();
            }

            public void postObjectRemoved(Process object, ProjectObject parent) {
                this.update();
            }

            public void objectChanged(Process projectObject, ProjectEvent event) {
                this.update();
            }

            public void objectReplaced(Process oldObject, Process newObject) {
                this.update();
            }

            private void update() {
                ViewProcessesPanel.this.processChecksPanel.reload();
                processesPanel.getParent().revalidate();
            }
        };
    }

    private final class CheckChangedListenerImpl
    implements MultipleCheckBoxPanel.CheckChangedListener {
        private final ConditionsComboBox relatedConditionsCombo;
        private final ViewRolesPanel rolesPanel;
        private final View view;

        private CheckChangedListenerImpl(View view, ViewRolesPanel rolesPanel, ConditionsComboBox relatedConditionsCombo) {
            this.view = view;
            this.rolesPanel = rolesPanel;
            this.relatedConditionsCombo = relatedConditionsCombo;
        }

        @Override
        public void checkChanged(MultipleCheckBoxPanel.CheckChangedEvent event) {
            String deployment = (String)event.getItem();
            String processName = ProcessDeploymentUtils.getProcessNameFromDeploymentId((String)deployment);
            Process process = ViewProcessesPanel.this.project.findProcess(processName);
            if (event.isSelected()) {
                this.view.assignProcess(deployment);
            } else {
                Sequence lanes = process.getLanes();
                if (lanes != null) {
                    for (Lane lane : lanes) {
                        String roleId;
                        Role role = lane.getRole();
                        if (role == null || this.isInAnotherAssignedProcess(process, roleId = role.getId())) continue;
                        this.view.removeRole(roleId);
                    }
                }
                this.view.removeProcess(deployment);
            }
            ViewProcessesPanel.this.addProcessComponentListener(process);
            this.reloadRolesAndConditions(this.view);
            ViewProcessesPanel.this.setDirty(true);
        }

        private boolean isInAnotherAssignedProcess(Process process, String roleId) {
            List assignedProcessesList = this.view.getAssignedProcessesList();
            boolean isInAnotherProcess = false;
            for (String assignedProcess : assignedProcessesList) {
                Process model = ViewProcessesPanel.this.project.findProcess(assignedProcess.substring(1));
                if (model == null || process.equals(model)) continue;
                isInAnotherProcess = true;
            }
            return isInAnotherProcess;
        }

        private void reloadRolesAndConditions(View v) {
            if (this.rolesPanel != null) {
                this.rolesPanel.load(v);
                this.rolesPanel.getParent().getParent().repaint();
            }
            if (this.relatedConditionsCombo != null) {
                this.relatedConditionsCombo.reload((InstancesView)v);
            }
        }
    }
}

