/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.panels;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.ViewPanel;
import oracle.bpm.designer.view.gui.components.PresentationPreviewCombo;
import oracle.bpm.designer.view.gui.components.PresentationPreviewPanel;
import oracle.bpm.designer.view.gui.models.PresentationPreviewComboModel;
import oracle.bpm.designer.view.gui.panels.ViewContainerPanel;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.SeparatorPanel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.msg.UIMsg;

public class ViewPresentationPanel
extends ViewContainerPanel {
    private PresentationPreviewCombo presentationCombo;
    private PresentationPreviewPanel presentationPreviewPanel;

    public ViewPresentationPanel(UiContainer parent, ViewPanel viewPanel, final InstancesView view) {
        super(parent, viewPanel);
        Project project = view.getProject();
        String columns = "5dlu, pref, 2dlu, pref, pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref";
        FormLayout layout = new FormLayout("5dlu, pref, 2dlu, pref, pref:grow, 5dlu", "5dlu, pref, 5dlu, pref, 5dlu, pref");
        this.setLayout((Layout)layout);
        CellConstraints cc = layout.createCellConstraints();
        SeparatorPanel presentationSeparator = new SeparatorPanel((UiContainer)this, DesignerMsg.VIEWS_PRESENTATION);
        Label previewLabel = Label.create((UiContainer)this, (Msg)UIMsg.PREVIEW);
        this.presentationCombo = new PresentationPreviewCombo((UiContainer)this, view.getProject(), this);
        this.presentationCombo.setToolTipMsg(DesignerMsg.PRESENTATION_TOOLTIP);
        Presentation presentation = project.getPresentationManager().getPresentation(view.getPresentation());
        this.presentationCombo.setSelectedItem(presentation);
        this.presentationPreviewPanel = new PresentationPreviewPanel((UiContainer)this, this.presentationCombo.getSelectedPresentation());
        this.presentationPreviewPanel.setToolTipText(DesignerMsg.PREVIEW_TOOLTIP.getString());
        this.presentationCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    Presentation selectedPresentation = (Presentation)e.getItem();
                    ViewPresentationPanel.this.presentationPreviewPanel.setPresentation(selectedPresentation);
                    ViewPresentationPanel.this.presentationPreviewPanel.drawTable();
                    String presentationId = selectedPresentation != null ? selectedPresentation.getId() : null;
                    view.setPresentation(presentationId);
                    ViewPresentationPanel.this.setDirty(true);
                }
            }
        });
        this.add((UiComponent)presentationSeparator, cc.xywh(1, 2, 6, 1));
        this.add((UiComponent)previewLabel, cc.xy(2, 4));
        this.add((UiComponent)this.presentationCombo, cc.xy(4, 4));
        this.add((UiComponent)this.presentationPreviewPanel, cc.xywh(2, 6, 4, 1));
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, (UiComponent)this.presentationCombo);
        this.setEnabled(enabled, (UiComponent)this.presentationPreviewPanel);
    }

    @Override
    public void synchronize() {
        if (this.presentationCombo != null) {
            PresentationPreviewComboModel model = (PresentationPreviewComboModel)this.presentationCombo.getModel();
            Object lastSelection = model.getSelectedItem();
            model.reload();
            this.presentationCombo.updateUI();
            this.presentationCombo.setSelectedItem(lastSelection);
        }
        if (this.presentationPreviewPanel != null) {
            this.presentationPreviewPanel.drawTable();
        }
    }

    protected void onDispose() {
        if (this.presentationPreviewPanel != null) {
            this.presentationCombo.dispose();
        }
    }
}

