/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.panels;

import java.util.Locale;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.ViewPanel;
import oracle.bpm.designer.view.gui.components.LocalesComboBox;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanel;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanelBuilder;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanelEvent;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanelListener;
import oracle.bpm.designer.view.gui.models.LabelRowPanelModel;
import oracle.bpm.designer.view.gui.models.LocalesComboModel;
import oracle.bpm.designer.view.gui.panels.ViewContainerPanel;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SeparatorPanel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;

public class ViewLabelsPanel
extends ViewContainerPanel {
    private UiComponent addLocaleButton;
    private RowPanel labelsTable;
    private LocalesComboBox localesCombo;
    private Project project;
    private ObjectPropertyListener propertyListener;

    public ViewLabelsPanel(UiContainer parent, ViewPanel viewPanel, View view) {
        super(parent, viewPanel);
        this.project = view.getProject();
        String cols = "5dlu, pref, 5dlu, max(80dlu;pref), 5dlu, pref, 5dlu, pref, 5dlu:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref 5dlu, pref, 5dlu, pref";
        FormLayout layout = new FormLayout("5dlu, pref, 5dlu, max(80dlu;pref), 5dlu, pref, 5dlu, pref, 5dlu:grow, 5dlu", "5dlu, pref, 5dlu, pref 5dlu, pref, 5dlu, pref");
        PanelBuilder builder = layout.createBuilder((Panel)this);
        CellConstraints cc = layout.createCellConstraints();
        this.localesCombo = new LocalesComboBox((UiContainer)this, new LocalesComboModel(this.project));
        this.localesCombo.setUsedLocalesFilter(view);
        final LabelRowPanelModel model = new LabelRowPanelModel(view);
        BaseAction addAction = new BaseAction(DesignerMsg.ADD){

            public void run() {
                Locale selectedLocale = ViewLabelsPanel.this.localesCombo.getSelectedLocale();
                model.addRow(new LabelRowPanelModel.LabelModel(selectedLocale, ""));
                ViewLabelsPanel.this.localesCombo.setUsedLocale(selectedLocale, true);
                if (ViewLabelsPanel.this.localesCombo.isEmpty()) {
                    ViewLabelsPanel.this.localesCombo.setSelectedIndex(-1);
                    ViewLabelsPanel.this.addLocaleButton.setEnabled(false);
                }
                ViewLabelsPanel.this.setDirty(true);
                ViewLabelsPanel.this.revalidate();
                ViewLabelsPanel.this.getParent().revalidate();
                ViewLabelsPanel.this.revalidateScrollPane((UiContainer)ViewLabelsPanel.this.labelsTable);
                ViewLabelsPanel.this.labelsTable.repaint();
            }
        };
        this.addLocaleButton = this.createButton(addAction);
        this.addLocaleButton.setEnabled(!this.localesCombo.isEmpty());
        this.labelsTable = new RowPanelBuilder(model).createRemovableRowsPanel((UiContainer)this);
        builder.add((UiComponent)new SeparatorPanel((UiContainer)this, DesignerMsg.LABELS), cc.xywh(1, 2, 10, 1));
        builder.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.LANGUAGE), cc.xy(2, 4));
        builder.add((UiComponent)this.localesCombo, cc.xy(4, 4));
        builder.add(this.addLocaleButton, cc.xy(6, 4));
        builder.add((UiComponent)this.labelsTable, cc.xywh(2, 6, 9, 1));
        this.addLabelsTableListener(view, this.labelsTable, this.localesCombo, this.addLocaleButton);
        this.addModelListener();
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, this.addLocaleButton);
        this.setEnabled(enabled, (UiComponent)this.localesCombo);
        this.setEnabled(enabled, (UiComponent)this.labelsTable);
    }

    protected void onDispose() {
        this.project.getPreferences().removePropertyObserver("availableLanguages", this.propertyListener);
    }

    private UiComponent createButton(BaseAction action) {
        ToolBar toolBar = new ToolBar((UiContainer)this);
        toolBar.add(action);
        return toolBar;
    }

    private void addModelListener() {
        this.propertyListener = new ObjectPropertyListener(){

            @Override
            public void propertyChanged(Object object, String propertyName) {
                ViewLabelsPanel.this.localesCombo.reload();
                ViewLabelsPanel.this.addLocaleButton.setEnabled(!ViewLabelsPanel.this.localesCombo.isEmpty());
            }
        };
        this.project.getPreferences().addPropertyObserver("availableLanguages", this.propertyListener);
    }

    private void addLabelsTableListener(final View view, final RowPanel table, final LocalesComboBox localesCombo, final UiComponent addButton) {
        table.addListener(new RowPanelListener(){

            @Override
            public void rowAdded(RowPanelEvent event) {
                view.setLabels(((LabelRowPanelModel)table.getModel()).getLabels());
                ViewLabelsPanel.this.setDirty(true);
            }

            @Override
            public void rowRemoved(RowPanelEvent event) {
                Locale locale = ((LabelRowPanelModel.LabelModel)event.getRow()).getLocale();
                localesCombo.setUsedLocale(locale, false);
                if (!addButton.isEnabled()) {
                    addButton.setEnabled(true);
                }
                view.setLabels(((LabelRowPanelModel)table.getModel()).getLabels());
                ViewLabelsPanel.this.setDirty(true);
            }

            @Override
            public void rowUpdated(RowPanelEvent event) {
                view.setLabels(((LabelRowPanelModel)table.getModel()).getLabels());
                ViewLabelsPanel.this.setDirty(true);
            }
        });
    }
}

