/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.panels;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.ViewPanel;
import oracle.bpm.designer.view.gui.panels.ViewContainerPanel;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SeparatorPanel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.view.ParticipantScope;

public class ViewFilterOptionsPanel
extends ViewContainerPanel {
    private CheckBox caseSensitiveCheck;
    private ComboBox participantScopeCombo;

    public ViewFilterOptionsPanel(UiContainer parent, ViewPanel viewPanel, InstancesView view) {
        super(parent, viewPanel);
        String cols = "5dlu, pref, 5dlu, pref, 5dlu:grow";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref";
        FormLayout layout = new FormLayout("5dlu, pref, 5dlu, pref, 5dlu:grow", "5dlu, pref, 5dlu, pref, 5dlu, pref");
        PanelBuilder builder = layout.createBuilder((Panel)this);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)new SeparatorPanel((UiContainer)this, DesignerMsg.FILTER_OPTIONS), cc.xywh(1, 2, 5, 1));
        builder.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.GET_INSTANCES_ASSIGNED_TO), cc.xy(2, 4));
        this.participantScopeCombo = this.createParticipantScopeCombo((UiContainer)this, view);
        builder.add((UiComponent)this.participantScopeCombo, cc.xy(4, 4));
        this.caseSensitiveCheck = this.createCaseSensitiveCheck((UiContainer)this, view);
        builder.add((UiComponent)this.caseSensitiveCheck, cc.xywh(2, 6, 3, 1));
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, (UiComponent)this.participantScopeCombo);
        this.setEnabled(enabled, (UiComponent)this.caseSensitiveCheck);
    }

    private ComboBox<ParticipantScope> createParticipantScopeCombo(UiContainer parent, final InstancesView view) {
        ComboBox participantScopeCombo = UiFactory.createComboBox((UiContainer)parent, (Object[])ParticipantScope.values());
        participantScopeCombo.setLabelProvider((LabelProvider)new LabelProvider.Default<ParticipantScope>(){

            public String getText(ParticipantScope element) {
                return element.getMsg().getString();
            }
        });
        ParticipantScope participantScope = view.getParticipantScope();
        if (participantScope != null) {
            participantScopeCombo.setSelectedItem((Object)participantScope);
        } else {
            participantScopeCombo.setSelectedIndex(0);
        }
        participantScopeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    view.setParticipantScope((ParticipantScope)e.getItem());
                    ViewFilterOptionsPanel.this.setDirty(true);
                }
            }
        });
        return participantScopeCombo;
    }

    private CheckBox createCaseSensitiveCheck(UiContainer parent, final InstancesView view) {
        CheckBox caseSensitiveCombo = CheckBox.create((UiContainer)parent, (Msg)DesignerMsg.CASE_SENSITIVE_MATCHING);
        caseSensitiveCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                view.setCaseSensitive(e.isStateSelected());
                ViewFilterOptionsPanel.this.setDirty(true);
            }
        });
        caseSensitiveCombo.setSelected(view.isCaseSensitiveFilterSelected());
        return caseSensitiveCombo;
    }
}

