/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.models.AbstractColumnsTableModel;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.view.Ordering;

public class SortingColumnsTableModel
extends AbstractColumnsTableModel {
    private final Presentation.Mutable presentation;
    private List<SortedColumn> sortingColumns = new ArrayList<SortedColumn>();
    private static final int NAME_COLUMN = 0;
    private static final int SORTING_COLUMN = 1;

    public SortingColumnsTableModel(Presentation presentation) {
        this.presentation = presentation.asMutable();
        this.loadColumns();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int columnIndex) {
        return columnIndex == 0 ? CoreMsg.NAME.getString() : DesignerMsg.SORTING.getString();
    }

    public int getRowCount() {
        return this.sortingColumns.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        SortedColumn column = this.sortingColumns.get(rowIndex);
        String result = columnIndex == 0 ? column.getColumnLabel() : (column.isAscending() ? DesignerMsg.ASCENDING.getString() : DesignerMsg.DESCENDING.getString());
        return result;
    }

    public void reload() {
        this.loadColumns();
        this.fireTableDataChanged();
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        SortedColumn column = this.sortingColumns.get(rowIndex);
        if (columnIndex == 1) {
            boolean ascending = DesignerMsg.ASCENDING.getString().equals(aValue);
            column.setAscending(ascending);
            this.presentation.updateSortingColumn(column.getColumn(), ascending);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    @Override
    public void addColumn(Presentation.Column column) {
        if (!this.contains(column)) {
            this.sortingColumns.add(new SortedColumn((Presentation)this.presentation, column));
            this.presentation.addSortingColumn(column);
            this.fireTableRowsInserted(this.sortingColumns.size(), this.sortingColumns.size());
        }
    }

    public void moveColumnDown(int row) {
        Collections.swap(this.sortingColumns, row, row + 1);
        this.presentation.moveSortingColumnDown(row);
        this.fireTableRowsUpdated(row, row + 1);
    }

    public void moveColumnUp(int row) {
        Collections.swap(this.sortingColumns, row, row - 1);
        this.presentation.moveSortingColumnUp(row);
        this.fireTableRowsUpdated(row - 1, row);
    }

    public void deleteColumn(int row) {
        SortedColumn sortedColumn = this.sortingColumns.remove(row);
        this.presentation.removeSortingColumn(sortedColumn.getColumn());
        this.fireTableRowsDeleted(row - 1, row);
    }

    public boolean contains(Presentation.Column column) {
        return this.sortingColumns.contains(new SortedColumn((Presentation)this.presentation, column, true)) || this.sortingColumns.contains(new SortedColumn((Presentation)this.presentation, column, false));
    }

    @Override
    public void removeColumn(Presentation.Column column) {
        SortedColumn sortedColumn = new SortedColumn((Presentation)this.presentation, column);
        if (!this.sortingColumns.remove(sortedColumn)) {
            sortedColumn.setAscending(!sortedColumn.isAscending());
            this.sortingColumns.remove(sortedColumn);
        }
        this.presentation.removeSortingColumn(column);
        this.fireTableDataChanged();
    }

    public void loadColumns() {
        int i;
        Ordering presentationOrdering = this.presentation.getOrdering();
        Ordering newOrdering = new Ordering();
        this.sortingColumns.clear();
        HashMap<String, Presentation.Column> availableColumns = new HashMap<String, Presentation.Column>();
        Presentation.Column[] columns = this.presentation.getColumns();
        for (i = 0; i < columns.length; ++i) {
            if (columns[i].getVarDefinition() == null) continue;
            availableColumns.put(columns[i].getId(), columns[i]);
        }
        for (i = 0; i < presentationOrdering.getEntryCount(); ++i) {
            Ordering.Entry entry = presentationOrdering.getEntry(i);
            Presentation.Column orderingColumn = (Presentation.Column)availableColumns.get(entry.getVariableId());
            if (orderingColumn == null) continue;
            this.sortingColumns.add(new SortedColumn((Presentation)this.presentation, orderingColumn, entry.isAscending()));
            newOrdering.add(entry.getVariableId(), entry.isAscending());
        }
        this.presentation.setOrdering(newOrdering);
    }

    public void store() {
        Ordering ordering = new Ordering();
        for (SortedColumn column : this.sortingColumns) {
            ordering.add(column.getVarDefinition().getId(), column.isAscending());
        }
        this.presentation.setOrdering(ordering);
    }

    @Override
    public Presentation.Column getRowItem(int row) {
        return this.sortingColumns.get(row).getColumn();
    }

    public static class SortedColumn {
        private boolean ascending;
        private Presentation.Column column;
        private final Presentation presentation;

        public SortedColumn(Presentation presentation, Presentation.Column column) {
            this.presentation = presentation;
            assert (column != null);
            this.ascending = true;
            this.column = column;
        }

        public SortedColumn(Presentation presentation, Presentation.Column column, boolean ascending) {
            this.presentation = presentation;
            assert (column != null);
            this.ascending = ascending;
            this.column = column;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }

        public Presentation.Column getColumn() {
            return this.column;
        }

        public String getColumnLabel() {
            return this.column.getLabel(this.presentation.getProject().getDefaultLanguage());
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public ProjectDataObject getVarDefinition() {
            return this.column.getVarDefinition();
        }

        public boolean equals(Object obj) {
            SortedColumn sortedColum = (SortedColumn)obj;
            boolean result = sortedColum.ascending == this.ascending && sortedColum.column.getId().equals(this.column.getId());
            return result;
        }
    }
}

