/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.models;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.models.AbstractColumnsTableModel;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.presentation.presentations.Presentation;

public class SelectedColumnsTableModel
extends AbstractColumnsTableModel {
    private Presentation.Mutable presentation;
    private List<Presentation.Column> selectedColumns;
    static final long serialVersionUID = 5971462183409907904L;
    static final long serialCheck = 9137199764338956230L;

    public SelectedColumnsTableModel(Presentation presentation) {
        this.presentation = presentation.asMutable();
        this.selectedColumns = new ArrayList<Presentation.Column>();
        this.loadColumns();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    public Class getColumnClass(int columnIndex) {
        Class result = null;
        switch (columnIndex) {
            case 0: {
                result = String.class;
                break;
            }
            case 1: {
                result = Integer.class;
            }
        }
        return result;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int columnIndex) {
        String result = "";
        switch (columnIndex) {
            case 0: {
                result = CoreMsg.NAME.getString();
                break;
            }
            case 1: {
                result = DesignerMsg.COLUMN_WIDTH.getString();
            }
        }
        return result;
    }

    public int getRowCount() {
        return this.selectedColumns.size();
    }

    @Override
    public Presentation.Column getRowItem(int row) {
        return this.selectedColumns.get(row);
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Presentation.Column column = this.selectedColumns.get(rowIndex);
        if (columnIndex == 1) {
            column.setSize(((Integer)value).intValue());
            this.presentation.setColumSize(rowIndex, ((Integer)value).intValue());
            this.fireTableDataChanged();
        }
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Presentation.Column column = this.selectedColumns.get(rowIndex);
        Object result = columnIndex == 0 ? column.getLabel(this.presentation.getProject().getDefaultLanguage()) : Long.valueOf(column.getSize());
        return result;
    }

    @Override
    public void addColumn(Presentation.Column column) {
        int lastRow = this.selectedColumns.size() - 1;
        this.presentation.addColumn(column);
        this.selectedColumns.add(column);
        this.fireTableRowsInserted(lastRow, this.selectedColumns.size() - 1);
    }

    public void addColumns(Presentation.Column[] columns) {
        int lastRow = this.selectedColumns.size() - 1;
        for (Presentation.Column column : columns) {
            this.presentation.addColumn(column);
            this.selectedColumns.add(column);
        }
        this.fireTableRowsInserted(lastRow, this.selectedColumns.size() - 1);
    }

    public void moveColumnDown(int row) {
        this.presentation.moveRowDown(row);
        this.loadColumns();
        this.fireTableDataChanged();
    }

    public void moveColumnUp(int row) {
        this.presentation.moveRowUp(row);
        this.loadColumns();
        this.fireTableDataChanged();
    }

    @Override
    public void removeColumn(Presentation.Column column) {
        this.presentation.removeColumn(column);
        int removedColumn = this.selectedColumns.indexOf(column);
        this.selectedColumns.remove(column);
        this.fireTableRowsDeleted(removedColumn, removedColumn + 1);
    }

    public void reload() {
        this.loadColumns();
        this.fireTableDataChanged();
    }

    private void loadColumns() {
        this.selectedColumns.clear();
        Presentation.Column[] columns = this.presentation.getColumns();
        ArrayList<Presentation.Column> list = new ArrayList<Presentation.Column>();
        for (Presentation.Column column : columns) {
            if (column.getVarDefinition() == null) continue;
            list.add(column);
        }
        this.selectedColumns.addAll(list);
    }
}

