/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.designer.view.gui.components.multiplecheckboxpanel.MultipleCheckBoxModel;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.project.model.presentation.views.ViewManager;

public class RolesPanelModel
implements MultipleCheckBoxModel {
    private Iterator iterator;
    private List<RolesCheck> rolesList;
    private View view;
    public static final String AUTOMATIC_HANDLER_ROLE = "AutomaticHandler";

    public RolesPanelModel(View view) {
        this.view = view;
        this.update();
    }

    @Override
    public void update() {
        this.iterator = null;
        this.rolesList = new ArrayList<RolesCheck>();
        List roles = this.view.getRoles();
        List assignedRoles = this.view.getAssignedRolesList();
        for (Role role : roles) {
            if (role.getId().equals(AUTOMATIC_HANDLER_ROLE)) continue;
            RolesCheck rolesCheck = new RolesCheck(role.getId());
            rolesCheck.setValue(assignedRoles.indexOf(role.getId()) != -1);
            this.rolesList.add(rolesCheck);
        }
        ViewManager viewManager = this.view.getProject().getViewManager();
        Collection unexistentRoles = viewManager.getNonexistentRolesIds(this.view.getId());
        for (String nonExistentRole : unexistentRoles) {
            if (nonExistentRole.equals(AUTOMATIC_HANDLER_ROLE)) continue;
            RolesCheck rolesCheck = new RolesCheck(nonExistentRole);
            rolesCheck.setValue(assignedRoles.indexOf(nonExistentRole) != -1);
            this.rolesList.add(rolesCheck);
        }
    }

    public View getView() {
        return this.view;
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.rolesList.iterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public MultipleCheckBoxModel.CheckBoxModel next() {
        if (this.iterator == null) {
            this.iterator = this.rolesList.iterator();
        }
        return (MultipleCheckBoxModel.CheckBoxModel)this.iterator.next();
    }

    static class RolesCheck
    implements MultipleCheckBoxModel.CheckBoxModel {
        private boolean checked;
        private String role;

        public RolesCheck(String role) {
            this.role = role;
            this.checked = false;
        }

        @Override
        public String getId() {
            return this.role;
        }

        @Override
        public String getLabel() {
            return this.role;
        }

        @Override
        public Object getObject() {
            return this.role;
        }

        @Override
        public void setValue(boolean checked) {
            this.checked = checked;
        }

        @Override
        public boolean getValue() {
            return this.checked;
        }
    }
}

