/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.models;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import oracle.bpm.designer.view.gui.components.multiplecheckboxpanel.MultipleCheckBoxModel;
import oracle.bpm.project.deployment.ProcessDeploymentUtils;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.deployment.ProcessDeployment;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.project.organization.OrganizationalUnitImpl;

public class ProcessesPanelModel
implements MultipleCheckBoxModel {
    private Iterator iterator;
    private Collection<ProcessCheck> processes;
    private final Project project;
    private final View view;

    public ProcessesPanelModel(Project project, View view) {
        this.project = project;
        this.view = view;
        this.update();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.processes.iterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public MultipleCheckBoxModel.CheckBoxModel next() {
        if (this.iterator == null) {
            this.iterator = this.processes.iterator();
        }
        return (MultipleCheckBoxModel.CheckBoxModel)this.iterator.next();
    }

    @Override
    public void update() {
        this.iterator = null;
        this.processes = new TreeSet<ProcessCheck>();
        Collection deployments = this.project.getDeployment().getTopology().getDeployments();
        List assignedProcesses = this.view.getAssignedProcessesList();
        for (ProcessDeployment deployment : deployments) {
            String processId = ProcessDeploymentUtils.getDeployedProcessId((ProcessDeployment)deployment);
            String processLabel = this.project.findProcess(ProcessDeploymentUtils.getProcessNameFromDeploymentId((String)processId)).getDefaultLabel();
            ProcessCheck processCheck = new ProcessCheck(ProcessDeploymentUtils.getDeployedProcessId((ProcessDeployment)deployment), processLabel);
            processCheck.setValue(assignedProcesses.indexOf(processId) != -1);
            this.processes.add(processCheck);
        }
    }

    static class ProcessCheck
    implements MultipleCheckBoxModel.CheckBoxModel,
    Comparable<ProcessCheck> {
        private boolean checked;
        private String processDeploymentId;
        private final String processLabel;

        public ProcessCheck(String processDeploymentId, String processLabel) {
            this.processDeploymentId = processDeploymentId;
            this.processLabel = processLabel;
            this.checked = false;
        }

        @Override
        public String getId() {
            return this.processDeploymentId;
        }

        @Override
        public String getLabel() {
            String label = this.processLabel;
            String ou = ProcessDeploymentUtils.getOUFromDeploymentId((String)this.processDeploymentId);
            if (!OrganizationalUnitImpl.isRootId((String)ou)) {
                label = label + " (" + ou + ")";
            }
            return label;
        }

        @Override
        public String getObject() {
            return this.processDeploymentId;
        }

        @Override
        public void setValue(boolean b) {
            this.checked = b;
        }

        @Override
        public boolean getValue() {
            return this.checked;
        }

        @Override
        public int compareTo(ProcessCheck other) {
            return this.getLabel().compareTo(other.getLabel());
        }
    }
}

