/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import oracle.bpm.project.ProcessIdsConverterUtils;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.deployment.ProcessDeployment;

public class ProcessComboModel
extends AbstractListModel
implements ComboBoxModel {
    private List<String> processesList;
    private final Project project;
    private int selectedProcess;
    static final long serialVersionUID = 1287349358721655847L;
    static final long serialCheck = -2212506111342547044L;

    public ProcessComboModel(Project project) {
        this.project = project;
        this.processesList = new ArrayList<String>();
        this.load();
    }

    @Override
    public Object getElementAt(int index) {
        return this.processesList.get(index);
    }

    public boolean isEmpty() {
        return this.processesList.size() == 0;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedProcess = this.processesList.indexOf(anItem);
    }

    @Override
    public String getSelectedItem() {
        return this.selectedProcess != -1 && this.processesList.size() != 0 ? this.processesList.get(this.selectedProcess) : null;
    }

    @Override
    public int getSize() {
        return this.processesList.size();
    }

    public void reload() {
        this.processesList.clear();
        this.load();
        this.fireContentsChanged(this, 0, this.processesList.size());
        this.fireIntervalAdded(this, 0, this.processesList.size());
    }

    private void load() {
        Collection deployments = this.project.getDeployment().getTopology().getDeployments();
        for (ProcessDeployment processDeployment : deployments) {
            String processId = ProcessIdsConverterUtils.deploymentToProjectProcessId((ProcessDeployment)processDeployment);
            if (this.project.findProcess(processId) == null) continue;
            this.processesList.add(ProcessIdsConverterUtils.getConsolidatedPapiId((ProcessDeployment)processDeployment));
        }
        Collections.sort(this.processesList);
    }
}

