/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.models;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import oracle.bpm.project.model.Project;

public class LocalesComboModel
extends AbstractListModel
implements ComboBoxModel {
    private List<Locale> availableLocales;
    private final Project project;
    private int selectedLocale;
    static final long serialVersionUID = 538183586181031113L;
    static final long serialCheck = -8187368049259396843L;

    public LocalesComboModel(Project project) {
        this.project = project;
        this.update();
        this.selectedLocale = -1;
    }

    public void update() {
        this.availableLocales = new ArrayList<Locale>(this.project.getAvailableLanguages());
    }

    @Override
    public Object getElementAt(int index) {
        return this.availableLocales.get(index);
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public void setLocaleUsed(Locale locale, boolean used) {
        if (used) {
            if (this.availableLocales.remove(locale)) {
                this.selectedLocale = this.availableLocales.size() != 0 ? 0 : -1;
                this.fireContentsChanged(this, 0, this.availableLocales.size());
            }
        } else {
            this.availableLocales.add(locale);
            this.fireContentsChanged(this, 0, this.availableLocales.size());
        }
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedLocale = this.availableLocales.indexOf(anItem);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedLocale != -1 ? this.availableLocales.get(this.selectedLocale) : null;
    }

    @Override
    public int getSize() {
        return this.availableLocales.size();
    }

    public void reload() {
        this.update();
        this.fireContentsChanged(this, 0, 0);
    }
}

