/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanelModel;
import oracle.bpm.project.model.presentation.views.View;

public class LabelRowPanelModel
extends RowPanelModel {
    private LocaleStringMap labels;
    private View view;

    public LabelRowPanelModel(View view) {
        this.view = view;
        this.labels = view.getLabels();
    }

    public Iterator<LabelModel> getAllRows() {
        ArrayList<LabelModel> labelsList = new ArrayList<LabelModel>();
        for (Locale locale : this.labels.keySet()) {
            if (locale == null) continue;
            labelsList.add(new LabelModel(locale, (String)this.labels.get((Object)locale)));
        }
        return labelsList.iterator();
    }

    public LocaleStringMap getLabels() {
        return this.labels;
    }

    @Override
    public RowPanelModel.RowModel getRow(Object id) {
        return new LabelModel((Locale)id, (String)this.labels.get((Object)((Locale)id)));
    }

    @Override
    protected void add(RowPanelModel.RowModel row) {
        LabelModel label = (LabelModel)row;
        this.view.setLabel((String)label.getValue(), label.getLocale());
    }

    @Override
    protected void remove(RowPanelModel.RowModel row) {
        LabelModel label = (LabelModel)row;
        this.view.removeLabel(label.getLocale());
    }

    @Override
    protected void update(Object id, Object value) {
        this.view.setLabel((String)value, (Locale)id);
    }

    public static class LabelModel
    implements RowPanelModel.RowModel {
        private Locale locale;
        private String value;

        public LabelModel(Locale locale, String label) {
            this.locale = locale;
            this.value = label;
        }

        @Override
        public String getDescription() {
            return this.locale.getDisplayName(this.locale);
        }

        @Override
        public Object getId() {
            return this.locale;
        }

        public Locale getLocale() {
            return this.locale;
        }

        @Override
        public void setValue(Object value) {
            this.value = (String)value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }
}

