/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpm.designer.view.gui.components.rowpanel.RowPanelModel;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.presentation.FilterAttribute;
import oracle.bpm.project.model.presentation.views.InstancesView;

public class FilterAttributeRowPanelModel
extends RowPanelModel {
    private Map<Integer, FilterAttributeModel> filterAttributes;
    private int id;
    private InstancesView view;

    public FilterAttributeRowPanelModel(InstancesView view) {
        this.view = view;
        this.filterAttributes = new HashMap<Integer, FilterAttributeModel>();
        List filterAttributeList = view.getFilterAttributes();
        for (FilterAttribute filterAttribute : filterAttributeList) {
            int i;
            ++this.id;
            Integer key = i;
            FilterAttributeModel filterAttributeModel = FilterAttributeRowPanelModel.createFilterAttributeModel(filterAttribute, key, view);
            if (filterAttributeModel == null) continue;
            this.filterAttributes.put(key, filterAttributeModel);
        }
    }

    public static FilterAttributeModel createFilterAttributeModel(FilterAttribute filterAttribute, Object id, InstancesView view) {
        FilterAttributeModel result;
        ProjectDataObject varDefinition = FilterAttributeRowPanelModel.getVarDefinition(filterAttribute.getVariableId(), view);
        if (varDefinition != null) {
            filterAttribute.setVariable(varDefinition);
            result = new FilterAttributeModel(filterAttribute, id);
        } else {
            result = null;
        }
        return result;
    }

    public Iterator<FilterAttributeModel> getAllRows() {
        ArrayList<FilterAttributeModel> filterAttributesList = new ArrayList<FilterAttributeModel>();
        for (Integer key : this.filterAttributes.keySet()) {
            FilterAttributeModel filterAttribute = this.filterAttributes.get(key);
            if (FilterAttributeRowPanelModel.getVarDefinition(filterAttribute.getValue().getVariableId(), this.view) == null) continue;
            filterAttributesList.add(filterAttribute);
        }
        return filterAttributesList.iterator();
    }

    public List<FilterAttribute> getFilterAttributes() {
        ArrayList<FilterAttribute> result = new ArrayList<FilterAttribute>();
        for (FilterAttributeModel filterAttribute : this.filterAttributes.values()) {
            result.add(filterAttribute.getValue());
        }
        return result;
    }

    @Override
    public RowPanelModel.RowModel getRow(Object id) {
        return this.filterAttributes.get(id);
    }

    public void addFilterAttribute(FilterAttribute filterAttribute) {
        this.addRow(FilterAttributeRowPanelModel.createFilterAttributeModel(filterAttribute, this.id, this.view));
        this.view.addFilterAttribute(filterAttribute);
        ++this.id;
    }

    @Override
    protected void add(RowPanelModel.RowModel row) {
        this.filterAttributes.put((Integer)row.getId(), (FilterAttributeModel)row);
    }

    @Override
    protected void remove(RowPanelModel.RowModel row) {
        this.filterAttributes.remove(row.getId());
    }

    @Override
    protected void update(Object id, Object value) {
        FilterAttributeModel filterAttributeModel = this.filterAttributes.get(id);
        filterAttributeModel.setValue(value);
    }

    private static ProjectDataObject getVarDefinition(String variableId, InstancesView view) {
        ProjectDataObject result = null;
        Collection list = view.getConditions();
        for (ProjectDataObject dataObject : list) {
            if (!variableId.equals(dataObject.getId())) continue;
            result = dataObject;
            break;
        }
        return result;
    }

    public static class FilterAttributeModel
    implements RowPanelModel.RowModel {
        private String description;
        private FilterAttribute filterAttribute;
        private Object id;

        private FilterAttributeModel(FilterAttribute filterAttribute, Object id) {
            this.filterAttribute = filterAttribute;
            this.description = filterAttribute.getVariable().getDefaultLabel();
            this.id = id;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Object getId() {
            return this.id;
        }

        @Override
        public void setValue(Object value) {
            this.filterAttribute = (FilterAttribute)value;
        }

        public FilterAttribute getValue() {
            return this.filterAttribute;
        }
    }
}

