/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectVariableLableComparator;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.project.model.processes.DataObject;

public class ConditionsComboModel
extends AbstractListModel
implements ComboBoxModel {
    private List<ProjectDataObject> conditionsList;
    private int selectedCondition;
    private final InstancesView view;
    static final long serialVersionUID = -1591592186431662701L;
    static final long serialCheck = -3741347411634691146L;

    public ConditionsComboModel(InstancesView view) {
        this.view = view;
        this.conditionsList = new ArrayList<ProjectDataObject>();
        this.selectedCondition = -1;
        this.view.getProject().addListener((ProjectListener)new ProjectListenerAdapter<DataObject>(DataObject.class){

            public void postObjectAdded(DataObject object, ProjectObject parent) {
                ConditionsComboModel.this.loadConditions();
                ConditionsComboModel.this.fireContentsChanged(ConditionsComboModel.this, 0, ConditionsComboModel.this.getSize());
            }

            public void postObjectRemoved(DataObject object, ProjectObject parent) {
                ConditionsComboModel.this.loadConditions();
                ConditionsComboModel.this.fireContentsChanged(ConditionsComboModel.this, 0, ConditionsComboModel.this.getSize());
            }
        });
        this.loadConditions();
    }

    @Override
    public Object getElementAt(int index) {
        return this.getSize() > 0 ? this.conditionsList.get(index) : null;
    }

    public boolean isEmpty() {
        return this.conditionsList.size() == 0;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedCondition = this.conditionsList.indexOf(anItem);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedCondition != -1 && this.conditionsList.size() > this.selectedCondition ? this.conditionsList.get(this.selectedCondition) : null;
    }

    @Override
    public int getSize() {
        return this.conditionsList.size();
    }

    public Class<DataObject> getSupportedTypes() {
        return DataObject.class;
    }

    private void loadConditions() {
        this.conditionsList.clear();
        this.conditionsList.addAll(this.view.getConditions());
        Collections.sort(this.conditionsList, new ProjectVariableLableComparator());
    }
}

