/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.view.gui.models;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import oracle.bpm.designer.view.gui.models.AbstractColumnsTableModel;
import oracle.bpm.designer.view.gui.models.ColumnsLabelsComparator;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.presentation.presentations.Presentation;

public class AvailableColumnsTableModel
extends AbstractColumnsTableModel {
    private List<Presentation.Column> availableColumns = new ArrayList<Presentation.Column>();
    private Presentation.Mutable presentation;
    static final long serialVersionUID = 3207305274501375236L;
    static final long serialCheck = -8629254119919390539L;

    public AvailableColumnsTableModel(Presentation presentation) {
        this.presentation = presentation.asMutable();
        this.loadColumns();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int columnIndex) {
        return CoreMsg.NAME.getString();
    }

    public int getRowCount() {
        return this.availableColumns.size();
    }

    @Override
    public Presentation.Column getRowItem(int row) {
        return this.availableColumns.get(row);
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Presentation.Column column = this.availableColumns.get(rowIndex);
        if (columnIndex == 1) {
            column.setSize(((Integer)value).intValue());
            this.presentation.setColumSize(rowIndex, ((Integer)value).intValue());
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Presentation.Column column = this.availableColumns.get(rowIndex);
        return column.getLabel(this.presentation.getProject().getDefaultLanguage());
    }

    @Override
    public void addColumn(Presentation.Column column) {
        int lastRow = this.availableColumns.size() - 1;
        this.availableColumns.add(column);
        this.fireTableRowsInserted(lastRow, this.availableColumns.size() - 1);
    }

    @Override
    public void removeColumn(Presentation.Column column) {
        int lastRow = this.availableColumns.size() - 1;
        this.availableColumns.remove(column);
        this.fireTableRowsInserted(lastRow, this.availableColumns.size() - 1);
    }

    public void reload() {
        this.loadColumns();
    }

    private void loadColumns() {
        TreeSet<Presentation.Column> set = new TreeSet<Presentation.Column>(new ColumnsLabelsComparator());
        set.addAll(this.presentation.getProject().getPresentationManager().getAvailableColumns((Presentation)this.presentation));
        this.availableColumns.clear();
        this.availableColumns.addAll(set);
    }
}

